#include <iostream.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "../rtstuff/Instrument.h"
#include "../rtstuff/rtdefs.h"
#include "../H/sfheader.h"

/* these are defined in rtinput.c */
extern char *rtsfname;
extern double inSR;
extern int inNCHANS;
extern int input_on;


int rtsetinput(float start, Instrument *theInst)
{
	long seekbytes,seeked;
#ifdef sgi
	AFfilehandle rtinfile;
#endif
#ifdef LINUX
	int audio_fd;
#endif
	int i,sf,result,headersize;
	struct stat sfst;
	float dur;
	SFHEADER sfh;
	int rtinfile;
	
									
	if (input_on) { /* take from input device, not file */
		theInst->inputsr = inSR;
		theInst->inputchans = inNCHANS;
		theInst->inputfd = AUDIO_DEVICE;
		return(1);
		}

	/* open the file */
	/* using the built-in cmix macros in sfheader.h */
	readopensf(rtsfname,sf,sfh,sfst,"head",result);
	
	inSR = sfsrate(&sfh);
	inNCHANS = sfchans(&sfh);
	
	theInst->inputsr = inSR;
	theInst->inputchans = inNCHANS;

	/* use a unix fd for future porting to other platforms
 	   need to do a reset of the fd if we plan to do any more
	   with SGI AF lib stuff... */

	theInst->inputfd = sf;

	seekbytes = ((int)(start * inSR)) * theInst->inputchans * sizeof(short);

	seeked = lseek(theInst->inputfd, seekbytes, SEEK_CUR);
	if (seeked == -1) {
		fprintf(stderr, "bad seek setting up the input soundfile\n");
		return(-1);
		}

// this is because SGI only allows ~196 open input audio files
	theInst->inputfd = dup(theInst->inputfd);
	close(sf);

	return(seeked);
}





