#include "../rtdefs.h"
#include "heap.h"
#include <iostream.h>


extern heap rtHeap;

void heapify(Instrument *Iptr)
{
  int nsamps,startsamp,startslot,endslot,endsamp;
  unsigned long chunkstart;
  int curslot;
  float start,dur;

  // Calculate variables for heap insertion
  dur = Iptr->getdur();
  nsamps = (int) (dur*SR);
//  cout << "nsamps = " << nsamps << endl;
  
  start = Iptr->getstart();
  startsamp = (int) (start*SR);
  startslot = startsamp/RTBUFSAMPS;
  
  endsamp = startsamp+nsamps;
  Iptr->setendsamp(endsamp);  // used by traverse.C
  
  endslot = endsamp/RTBUFSAMPS;
  
  // place instrument into heap
  chunkstart = startsamp;
  curslot = startslot;
  while(curslot <= endslot) {
//    cout << "curslot = " << curslot << "\n";
//    cout << "rtHeap.insert(Iptr, " << chunkstart << ")\n";
    rtHeap.insert(Iptr, chunkstart);
    curslot++;
    chunkstart = (unsigned long)curslot*RTBUFSAMPS;
  }
}

