#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h> 
#include <math.h>
#define IWRAP(x,y) (((x)>=(y))?(x)-(y):(((x)<0)?(x)+(y):(x)))
#define SIZE 512
#define SIZEOF_HEADER 1024 /* I added this on the NeXT - bgg */

extern float SR;

extern SFHEADER      sfdesc[NFILES];
extern float array[SIZE],tabs[2];      /* for lineset */
extern int lineset;

double
trans (p,n_args)
    float *p;
    int n_args;
{
    extern struct stat sfst[NFILES];
    double increment, counter = 0.0, frac, amp;
    double voldsig[4], oldsig[4], newsig[4], dur, interval, interp();
    float input[4], sig[4];
    register int getflag = 1, incount = 1, i, j, z;
    register long int insamps, outsamps, outcount = 0;
    register int nchans = sfchans(&sfdesc[0]);

/*  p0 = inskp  p1 = outskp  p2 = dur (tmnd)  p3 = intrvl of trnsp. p4 = amp */

/*    SR = sfsrate(&sfdesc[0]); */
    if(n_args != 5)
    {
         fprintf(stderr, "Wrong number of args for trans!\n");
         return;
    }
    interval = octpch(p[3]);  /* convert interval to lin octave */
    increment = cpsoct(10.0+interval)/cpsoct(10.0);  /* the samp incr. */
    if (p[2] == 0.0)
        p[2] = ((float)(sfst[0].st_size - SIZEOF_HEADER)
                 /(float)sfclass(&sfdesc[0])/(float)sfchans(&sfdesc[0])
                 /sfsrate(&sfdesc[0])) - p[0];

    dur = (p[2]<0.0)? -1.0*p[2] : p[2] - p[0];       /* p2 is dur if neg. */
    insamps = setnote(p[0], dur, 0);                 /* set input file */
    outsamps = setnote(p[1], (dur/increment), 1);    /* set output file */
    if(!lineset) 
    {
        for(j = 0; j < SIZE; j++) array[j] = 1;
        fprintf(stderr,"Set phrase curve to all 1's\n");
        lineset = 1;
    }
    z = SR/10000;               /* the control rate for amp curve */
    j = 0;
    tableset(dur/increment, SIZE, tabs);           /* set up table for amp */
    GETIN(input,0);
    for(i=0; i < nchans; i++) oldsig[i] = input[i];
    GETIN(input,0);
    for(i=0; i < nchans; i++) newsig[i] = input[i];

    /* the processing loop for the input signal */

    while (outcount++ < outsamps)
    {
        while (getflag)
        {
                GETIN(input,0);                        /* get input samp */ 
                for(i=0; i < nchans; i++)
                {
                   voldsig[i] = oldsig[i];
                   oldsig[i] = newsig[i];
                   newsig[i] = input[i];
                }
                incount++;  
                if ((counter - (float)incount) < 0.5) getflag = 0;
        }
        frac = counter - incount + 2.0;   /* The interp value */
        while (!j--)
        {
                amp = tablei(outcount,array,tabs) * p[4];
                j = z;
        }
        for(i=0; i < nchans; i++)
                sig[i] = interp(voldsig[i], oldsig[i], newsig[i], frac)*amp;
        ADDOUT(sig, 1);
        counter += increment;               /* keeps track of interp pointer */
        if ((counter - (float)incount) >= -0.5) getflag = 1; /* Ready for samp */
    }
    endnote(1);
}

double interp(y0,y1,y2,t)
    register double t, y0, y1, y2;
{
    register double hy2, hy0, a, b, c;
    
    a = y0;
    hy0 = y0/2.0;
    hy2 =  y2/2.0;
    b = (-3.0 * hy0) + (2.0 * y1) - hy2;
    c = hy0 - y1 + hy2;

    return(a + b*t + c*t*t);
}


int NBYTES = 16384;
 
profile()
{
UG_INTRO("trans", trans);
UG_INTRO("setline", setline);
}

