#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern  strumq strumq1;

scomb(p,n_args)
 float *p;
 int n_args;

 /* program to use strum routine and structure as swept comb filter */
 /* scomb(start, dur, inskip, pitch0, pitch1, sweepfcn, tf0, tNy */
 /* Uses file 1 as input, 0 as output
    tf0 is reverb time at fundamental freq, tNy is reverb time at high
    harmonics (Nyquist frequency)*/

  {
  float freq,freq0,freq1,out[4],strum();
  float diff,*glissf,tags[4],xin[4];
  int gliss,leng,j;
  long i,nsamps;

  out[0]=out[1]=out[2]=out[3]=0.0;

  setnote(p[2],p[1],0);
  nsamps=setnote(p[0],p[1],1);

  freq0=cpspch(p[3]);
  freq1=cpspch(p[4]);
  diff = freq1 - freq0;

  sset(freq0,p[6],p[7],&strumq1);

  gliss = p[5];

  glissf = (float *)floc(gliss);  /*function p[4] is gliss shape */
  leng = fsize(gliss);

  j = SR/freq0; /*interrupt  once per cycle*/

  tableset(p[1],leng,tags);

        for(i = 0; i<nsamps; i++) {
                if(!j--) {  
                        freq = diff*tablei(i,glissf,tags) + freq0;
                        sset(freq,p[5],p[6],&strumq1);
                        j = (float)SR/freq;
                }  
        GETIN(xin,0);
        out[0]=strum(xin[0],&strumq1);
        ADDOUT(out,1);
        }
  
  endnote(1);
}
