#define maxdl 14000
#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern   strumq strumq1;
extern   strumq strumq2;
extern   strumq strumq3;
extern   strumq strumq4;
extern   strumq strumq5;
extern   strumq strumq6;
typedef struct {
        int p,del;
        float d[maxdl],c1,c2;
        } delayq;
extern  delayq dq;

pick6(p,n_args)
 float *p;
 int n_args;

/* 6-string guitar with delay and distortion
   like start4.c--see that source code for more info.
   pick6(star, dur, pitch, pitch, pitch, p,p,p, decay time,
   Ny freq decayt, dist gain, loop gain, loop pitch, premonitor,
   postmonitor, plamp,squish)   */

  {
  float out[4],strum(),dist(),delay();
  float freq1,freq2,freq3,freq4,freq5,freq6,a,b,d,dgain,fbgain;
  int squish;
  long i,nsamps;

  out[0]=out[1]=out[2]=out[3]=0.0;
  d = 0;

  nsamps=setnote(p[0],p[1],1);

  freq1=cpspch(p[2]);
  freq2=cpspch(p[3]);
  freq3=cpspch(p[4]);
  freq4=cpspch(p[5]);
  freq5=cpspch(p[6]);
  freq6=cpspch(p[7]);
   
  dgain = p[10];
  fbgain = p[11]/dgain;
  sset(freq1,p[8],p[9],&strumq1);
  sset(freq2,p[8],p[9],&strumq2);
  sset(freq3,p[8],p[9],&strumq3);
  sset(freq4,p[8],p[9],&strumq4);
  sset(freq5,p[8],p[9],&strumq5);
  sset(freq6,p[8],p[9],&strumq6);

  squish = p[16];
  randfill(p[15],squish,&strumq1);
  randfill(p[15],squish,&strumq2);
  randfill(p[15],squish,&strumq3);
  randfill(p[15],squish,&strumq4);
  randfill(p[15],squish,&strumq5);
  randfill(p[15],squish,&strumq6);
  delayset(cpspch(p[12]),&dq);
  printf("set completed\n");


  for (i=0;i<nsamps;i++) {
      a = strum(d,&strumq1);
      a += strum(d,&strumq2);
      a += strum(d,&strumq3);
      a += strum(d,&strumq4);
      a += strum(d,&strumq5);
      a += strum(d,&strumq6);

      b = dist(dgain*a);
      d = fbgain*delay(b,&dq);
      out[0] = p[13]*a + p[14]*b;
      ADDOUT(out,1);
      }
      printf("loopcompleted\n");
  
  endnote(1);
}
