#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>
#include "metaflute.h"


/* sflute -- Perry Cook's flute physical model
*
*  p0 = start
*  p1 = dur
*  p2 = noise amp
*  p3 = length1
*  p4 = length2
*  p5 = amp multiplier
*  p6 = stereo spread (0-1) <optional>
*  function slot 1 is the noise amp envelope
*  function slot 2 is the output amp envelope
*
*/


double
sflute(p,n_args)
float p[];
int n_args;
{
        long i,nsamps;
	int j,skip,dl1[2],dl2[2],length1,length2,imax;
	float del1[DELSIZE],del2[DELSIZE];
        float out[2],amp,oamp,sig,del1sig,oldsig;
	float *amparr,amptabs[2];
	int lenamp,chans;
	float *oamparr,oamptabs[2];
	int olenamp;
	extern int resetval;
	extern float mdelget();
	extern int mdelset();
        
        nsamps = setnote(p[0],p[1],1);

	amparr = floc(1);
	lenamp = fsize(1);
        tableset(p[1], lenamp, amptabs);

	oamparr = floc(2);
	olenamp = fsize(2);
        tableset(p[1], olenamp, oamptabs);

	imax = DELSIZE;
	mdelset(del1,dl1,imax);
	mdelset(del2,dl2,imax);

/*	srrand(0.1); */

	length1 = p[3];
	length2 = p[4];

	chans = sfchans(&sfdesc[1]);

	j = 0;
	skip = SR/(float)resetval;
	oldsig = 0; /* for the filter */
        for (i = 0; i < nsamps; i++) {
                while (!j--) {
                         amp = tablei(i,amparr,amptabs);
                         oamp = tablei(i,oamparr,oamptabs);
                         j = skip;
                         }

		sig = (rrand() * p[2] * amp) + amp;
		del1sig = mdelget(del1,length1,dl1);
		sig = sig + (del1sig * -0.35);
		delput(sig,del2,dl2);

		sig = mdelget(del2,length2,dl2);
		sig = (sig * sig * sig) - sig;
		sig = (0.4 * sig) + (0.9 * del1sig);
		out[0] = sig * p[5] * oamp;
		sig = (0.7 * sig) + (0.3 * oldsig);
		oldsig = sig;
		delput(sig,del1,dl1);

		if (chans > 1) { /* split stereo files between the channels */
			out[1] = (1.0 - p[6]) * out[0];
			out[0] *= p[6];
			}

                ADDOUT(out,1);
                }

       endnote(1);
}

