#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>
#include "metaflute.h"


/* bsflute -- pitch-bending version of Perry Cook's flute physical model
*
*  p0 = start
*  p1 = dur
*  p2 = noise amp
*  p3 = length1low
*  p4 = length1high
*  p5 = length2low 
*  p6 = length2high
*  p7 = amp multiplier
*  p8 = stereo spread (0-1) <optional>
*  function slot 1 is the noise amp envelope
*  function slot 2 is the output amp envelope
*  function slot 3 is the pitch-tracking curve for length 1
*  function slot 4 is the pitch-tracking curve for length 2
*
*/

double
bsflute(p,n_args)

float *p;

{
        long i,nsamps;
	int j,skip,dl1[2],dl2[2],imax;
	float length1,length2;
	float del1[DELSIZE],del2[DELSIZE];
        float out[2],amp,oamp,sig,del1sig,oldsig;
	float *amparr,amptabs[2];
	int lenamp,chans;
	float *oamparr,oamptabs[2];
	int olenamp;
	float *pcurve1,*pcurve2,ptabs1[2],ptabs2[2];
	int psize1,psize2;
	extern float mdliget();
	extern int mdelset();
	extern int resetval;


	nsamps = setnote(p[0],p[1],1);

	amparr = floc(1);
	lenamp = fsize(1);
	tableset(p[1], lenamp, amptabs);

	oamparr = floc(2);
	olenamp = fsize(2);
	tableset(p[1], olenamp, oamptabs);

	pcurve1 = floc(3);
	psize1 = fsize(3);
	tableset(p[1],psize1,ptabs1);

	pcurve2 = floc(4);
	psize2 = fsize(4);
	tableset(p[1],psize2,ptabs2);

	imax = DELSIZE;
	mdelset(del1,dl1,imax);
	mdelset(del2,dl2,imax);

/*	srrand(0.1); */

	chans = sfchans(&sfdesc[1]);

	j = 0;
	skip = SR/(float)resetval;
	oldsig = 0; /* for the filter */
	for (i = 0; i < nsamps; i++) {
		while (!j--) {
			amp = tablei(i,amparr,amptabs);
			oamp = tablei(i,oamparr,oamptabs);
			length1 = p[3] + ((p[4]-p[3]) *  tablei(i,pcurve1,ptabs1));
			length2 = p[5] + ((p[6]-p[5]) * tablei(i,pcurve2,ptabs2));
			j = skip;
			}

		sig = (rrand() * p[2] * amp) + amp;
		del1sig = mdliget(del1,length1,dl1);
		sig = sig + (del1sig * -0.35);
		delput(sig,del2,dl2);

		sig = mdliget(del2,length2,dl2);
		sig = (sig * sig * sig) - sig;
		sig = (0.4 * sig) + (0.9 * del1sig);
		out[0] = sig * p[7];
		sig = (0.7 * sig) + (0.3 * oldsig);
		oldsig = sig;
		delput(sig,del1,dl1);

		if (chans > 1) { /* split stereo files between the channels */
			out[1] = (1.0 - p[8]) * out[0];
			out[0] *= p[8];
			}

		ADDOUT(out,1);
		}

	endnote(1);
}
