#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "../../macros/macros.h"

extern SFHEADER      sfdesc[NFILES];

/* fminst -- simple fm instrument
*
*  p0 = start time
*  p1 = duration
*  p2 = pitch of carrier (hz or oct.pc)
*  p3 = pitch of modulator (hz or oct.pc)
*  p4 = fm index low point
*  p5 = fm index high point
*  p6 = amp
*  p7 = stereo spread (0-1) <optional>
*  function slot 1 is oscillator waveform, slot 2 is the amp envelope,
*     slot 3 is index guide
*/

double fminst(p,n_args)
float *p;
{

        int nsamps, i;
        float sicar, simod, val, out[2];
	float *indexenv, *sine, *ampenv;
	int lensine, lenind, lenamp;
        float indtabs[2], amptabs[2],  modphs, carphs;
        float index, amp, diff;
        int skip, j;
	int chans;
	extern int resetval;


	/* writes on cmix file 1 */
        nsamps = setnote(p[0],p[1],1);

        sine = floc(1);    /* function 1 is sine wave */
	lensine = fsize(1);
	if (p[2] < 15.0) { /* oct.pc trap */
		sicar = cpspch(p[2]) * lensine/SR; /* convert cps to si */
		}
	else {
		sicar = p[2] * lensine/SR;
		}

	if (p[3] < 15.0) {
		simod = cpspch(p[3]) * lensine/SR;
		}
	else {
		simod = p[3] * lensine/SR;
		}

	ampenv = floc(2);
	lenamp = fsize(2);
	tableset(p[1], lenamp, amptabs);

        indexenv = floc(3);  /* function 2 is index guide */
	lenind = fsize(3);
	tableset(p[1], lenind, indtabs);

	p[4] *= simod;
	diff = (p[5] * simod) - p[4];

	chans = sfchans(&sfdesc[1]);

        modphs = carphs = 0;
        skip = SR/(float)resetval;
	for(i=j=0; i<nsamps; i++) {
                if(!j--) {
                        amp = table(i, ampenv, amptabs) * p[6];
                        index = diff * tablei(i,indexenv,indtabs) + p[4];
                        j = skip;
                }

                val = oscil(index,simod,sine,lensine,&modphs); 
		/* osciln allows negative sampling increment */
                out[0] = osciln(amp,sicar+val,sine,lensine,&carphs);

		if (chans > 1) { /* split stereo files between the channels */
			out[1] = (1.0 - p[7]) * out[0];
			out[0] *= p[7];
			}

                ADDOUT(out,1);   /* additive writes */
        }
        endnote(1);
}


int NBYTES = 32768;
 
profile()
{
	UG_INTRO("fminst",fminst);
	UG_INTRO("reset",reset);
}
