#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>

#define DELSIZE 100
extern SFHEADER      sfdesc[NFILES];

/* clar -- Perry Cook's clarinet physical model
*
*  p0 = start
*  p1 = dur
*  p2 = noise amp
*  p3 = length1
*  p4 = length2
*  p5 = output amp
*  p6 = d2 gain
*  p7 = stereo spread (0-1) <optional>
*  function slot 1 is the amp envelope
*
*/

 
double
clar(p,n_args)

float *p;

{
	long i,nsamps;
	int j,skip,dl1[2],dl2[2],length1,length2,imax;
	float del1[DELSIZE],del2[DELSIZE];
	float out[2],amp,sig,csig,ssig,del1sig,del2sig,oldsig;
	float *amparr,amptabs[2];
	int lenamp,chans;
	float *oamparr,oamptabs[2];
	int olenamp;
	float oamp;
	float mdelget();
	extern int resetval;

	nsamps = setnote(p[0],p[1],1);

	amparr = floc(1);
	lenamp = fsize(1);
	tableset(p[1], lenamp, amptabs);

	oamparr = floc(2);
	olenamp = fsize(2);
	tableset(p[1], olenamp, oamptabs);

	imax = DELSIZE;
	mdelset(del1,dl1,imax);
	mdelset(del2,dl2,imax);

/*	srrand(0.1); */

	chans = sfchans(&sfdesc[1]);

	j = 0;
	skip = SR/(float)resetval;
	length1 = p[3];
	length2 = p[4];
	oldsig = 0; /* for the filter */
	for (i = 0; i < nsamps; i++) {
		while (!j--) {
			amp = tablei(i,amparr,amptabs);
			oamp = tablei(i,oamparr,oamptabs);
			j = skip;
			}

		sig = (rrand() * p[2] * amp) + amp;
		del1sig = mdelget(del1,length1,dl1);
		del2sig = mdelget(del2,length2,dl2);
		if (del1sig > 1.0) del1sig = 1.0;
		if (del1sig < -1.0) del1sig = -1.0;
		if (del2sig > 1.0) del2sig = 1.0;
		if (del2sig < -1.0) del2sig = -1.0;
		sig = sig + 0.9 * ((p[6] * del2sig) + ((0.9-p[6]) * del1sig));
		csig = -0.5 * sig + amp;
		ssig = sig * sig;
		sig = (0.3 * ssig) + (-0.8 * (sig * ssig));
		sig = sig + csig;
		sig = (0.7 * sig) + (0.3 * oldsig); /* incorrect filter? */
		oldsig = sig;
		delput(sig,del2,dl2);
		delput(sig,del1,dl1);
		out[0] = sig * p[5] * oamp;

		if (chans > 1) {
			out[1] = (1.0 - p[7]) * out[0];
			out[0] *= p[7];
			}

		ADDOUT(out,1);
		}

	endnote(1);
}


mdelset(a,l,imax)
float *a;
int *l,imax;
{
/* delay initialization.  a is address of float array, l is size-2 int
 * array for bookkeeping variables, xmax, is maximum expected delay */

	int i;
	*l = 0;
	*(l+1) = imax;
	for(i = 0; i < *(l+1); i++) *(a+i) = 0;
}



float mdelget(a,samps,l)
float *a;
int *l,samps;
{
/*  get value from delay line, samps samples delayed */

	register i = *l - samps;
	if(i < 0)  {
		i += *(l+1);
		if(i < 0) return(0);
		}
	return(*(a+i));
}


int NBYTES = 16384;
 
profile()
{
	UG_INTRO("clar",clar);
}

