#include <iostream.h>
#include "../../sys/mixerr.h"
#include "../../rtstuff/Instrument.h"
#include "START.h"
#include "../../rtstuff/rt.h"
#include "../../rtstuff/rtdefs.h"

strumq *curstrumq[6];

extern "C" {
	#include "../../H/ugens.h"
	void sset(float, float, float, strumq*);
	void randfill(float, int, strumq*);
	float strum(float, strumq*);
}

START::START() : Instrument()
{
	// future setup here?
}

int START::init(float p[], short n_args)
{
// p0 = start; p1 = dur; p2 = pitch (oct.pc); p3 = fundamental decay time
// p4 = nyquist decay time; p5 = amp, p6 = squish; p7 = stereo spread [optional]

	float freq;

	start = p[0];
	dur = p[1];

	strumq1 = new strumq;
	curstrumq[0] = strumq1;
	freq=cpspch(p[2]);
	sset(freq, p[3], p[4], strumq1);
	randfill(p[5], (int)p[6], strumq1);

	spread = p[7];
}

int START::run()
{
	int i;
	float out[2];

	for (i = 0; i < chunksamps; i++) {
		out[0] = strum(0.,strumq1);

		if (NCHANS == 2) { /* split stereo files between the channels */
			out[1] = (1.0 - spread) * out[0];
			out[0] *= spread;
			}

		rtaddout(out);
		cursamp++;
	}
	return i;
}

Instrument*
makeSTART()
{
	START *inst;

	inst = new START();
	return inst;
}

