#include <stdio.h>
#include <string.h>
#include "../H/ugens.h"
#include "../sys/mixerr.h"
#include "defs.h"

struct ug_item *ug_list;
extern int print_is_on;

double checkfuncs(char *fname, double *pp, short n_args)
{
	int i;
	struct ug_item *ug_p;
	double rv;
	float p[MAXDISPARGS];

	mixerr = MX_FNAME;
	/*  Find the routine that goes with named function      */
	ug_p = ug_list;
	while (ug_p) {
		if((rv=strcmp(ug_p->ug_name,fname)) == 0) {
			/* convert to floats */
			for(i = 0; i < n_args; i++) {
			  p[i] = (float)pp[i];
			}
			for(i = n_args; i < MAXDISPARGS; i++)
			  p[i] = pp[i] = 0.0;
			if(print_is_on) {
				printf ("============================\n");
				printf ("%s:  ",fname);
				for (i = 0; i < n_args; i++) {
					printf ("%g ",pp[i]);
					}
				printf ("\n");
				}
			/*  Call the function   */
			rv = (double)( *(ug_p->ug_ptr))(p, n_args, pp);
			mixerr = MX_NOERR; /* we found one */
			return (rv);
			}
		ug_p = ug_p->ug_next;
		}
	/* didn't find anything */
	return -1; /* same problem as earlier cmixes... */
}



