#include "../rtstuff/Instrument.h"
#include "../rtstuff/rt.h"
#include "../rtstuff/rtdefs.h"
#include "../sys/mixerr.h"
#include <string.h>
#include <iostream.h>
#include "defs.h"

rt_item *rt_list;
extern int print_is_on;

double checkInsts(char *fname, double *pp, short n_args)
{
	int i;
	rt_item *rt_p;
	Instrument *Iptr;
	double rv;
	float p[MAXDISPARGS];

	/* convert pp to floats */
	for(i = 0; i < n_args; i++) p[i] = (float)pp[i];
	/* and zero out the rest */
	for(i = n_args; i < MAXDISPARGS; i++) p[i] = pp[i] = 0.0;

	mixerr = MX_FNAME;
	rt_p = rt_list;
	while (rt_p) {
		if((rv=strcmp(rt_p->rt_name,fname)) == 0) {
			if(print_is_on) {
				printf ("========<rt-queueing>=======\n");
				printf ("%s:  ",fname);
				for (i = 0; i < n_args; i++)  printf ("%f ",p[i]);
				printf("\n");
				}

			/* set up the Instrument */
			Iptr = (*(rt_p->rt_ptr))();
			Iptr->init(p,n_args);

			/* insert / chop Instrument into heap / chunks */
			heapify(Iptr);

			rv = 1;
			mixerr = MX_NOERR;
			return rv;
			}

		rt_p = rt_p->rt_next;
		}
	return 0; /* This was NULL on SGI's ... not good */
}

