#include "../H/sfheader.h"
#include "../H/ugens.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>


static SFCODE   ampcode = {
        SF_MAXAMP,
        sizeof(SFMAXAMP) + sizeof(SFCODE)
};
#if defined(NeXT) || defined(NEXT)
Nwheader(sf,header)
SFHEADER  *header;
int sf;
{
        (header)->sfinfo.NeXTheader.magic = SND_MAGIC;
        (header)->sfinfo.NeXTheader.dataLocation = SIZEOF_BSD_HEADER;
        if((header)->sfinfo.sf_packmode == SF_FLOAT) 
                (header)->sfinfo.NeXTheader.dataFormat = SND_FORMAT_FLOAT;
        else    (header)->sfinfo.NeXTheader.dataFormat = SND_FORMAT_LINEAR_16;
        (header)->sfinfo.NeXTheader.samplingRate = (header)->sfinfo.sf_srate;
        (header)->sfinfo.NeXTheader.channelCount = (header)->sfinfo.sf_chans;
        if(header->sfinfo.sf_magic)  /* only write if it is BSD soundfile*/
                if(write(sf,header,SIZEOF_BSD_HEADER) 
                        != SIZEOF_BSD_HEADER) return(1);
        else return(0);
}

/* this is no longer used -- replaced by readHeader in sfcodes.c */
#if (0)
DoubleHeader(sf,header)
SFHEADER *header;
int sf;
{
        int i,j;
        char *pointer;
        SFMAXAMP sfmnew;
/* create dummy header in cases where there is only a Next Header */
        if((i=read(sf,header,SIZEOF_BSD_HEADER)) !=SIZEOF_BSD_HEADER) return(-1);
        if((header)->sfinfo.sf_magic == SF_MAGIC) return(1);
        if((header)->sfinfo.NeXTheader.magic != SND_MAGIC) return(-1);

        /* this is a next soundfile so zero out bytes after NeXT header */
        pointer = (char *)header;
        for(j=29; j<i; j++)  *(pointer+j) = 0;

        (header)->sfinfo.sf_magic = 0; /* to assure that we don't write */
        (header)->sfinfo.sf_srate = (header)->sfinfo.NeXTheader.samplingRate;
        (header)->sfinfo.sf_chans = (header)->sfinfo.NeXTheader.channelCount;
        if((header)->sfinfo.NeXTheader.dataFormat == SND_FORMAT_FLOAT)
                (header)->sfinfo.sf_packmode = SF_FLOAT;
        else if(((header)->sfinfo.NeXTheader.dataFormat == SND_FORMAT_LINEAR_16)
                || ((header)->sfinfo.NeXTheader.dataFormat == SND_FORMAT_COMPRESSED))
                (header)->sfinfo.sf_packmode = SF_SHORT;
        else {
                printf("unknown data type for Cmix %d\n",(header)->sfinfo.NeXTheader.dataFormat);
                exit(-99);
        }

        for(i=0; i<2 /*(header)->sfinfo.sf_chans*/; i++) {
                        sfmaxamp(&sfmnew,i)=0;
                        sfmaxamploc(&sfmnew,i)=0;
                }
                sfmaxamptime(&sfmnew) = 0;
                putsfcode(header,&sfmnew,&ampcode);
        return(2);
}

#endif 

getheadersize(header)
SFHEADER *header;
{
        if((header)->sfinfo.sf_magic == 0) return((header)->sfinfo.NeXTheader.dataLocation);
        else return(SIZEOF_BSD_HEADER);
}

putlength(sfname,sf,header)
SFHEADER *header;
char *sfname;
{
        struct stat st;
        if(stat(sfname,&st))  {
                printf("Couldn't stat file\n");
                return(-1);
        }
        if(lseek(sf,0,0) < 0)
                 printf("Bad lseek trying to write NeXT header\n");
        (header)->sfinfo.NeXTheader.dataSize = (int)st.st_size - SIZEOF_BSD_HEADER;
        if(write(sf,header,SIZEOF_BSD_HEADER) != SIZEOF_BSD_HEADER) {
                printf("Bad header write on file\n");
        }
}
#endif
