#include "../H/ugens.h"
#include "../H/sfheader.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>


extern SFHEADER      sfdesc[NFILES];
extern SFMAXAMP      sfm[NFILES];
extern struct stat   sfst[NFILES];
extern int headersize[NFILES];

static SFCODE ampcode = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
};
double _sr(p,n_args)
float *p;
{
	return(sfsrate(&sfdesc[(int)p[0]]));
}
double _chans(p,n_args)
float *p;
{
	return(sfchans(&sfdesc[(int)p[0]]));
}
double _class(p,n_args)
float *p;
{
	return(sfclass(&sfdesc[(int)p[0]]));
}
double _dur(p,n_args)
float *p;
{
	char *cp,*getsfcode();
	int i;
	float dur;
	i = p[0];
	cp = getsfcode(&sfdesc[i],SF_MAXAMP);
	bcopy(cp + sizeof(SFCODE), (char *) &sfm[i], sizeof(SFMAXAMP));
	dur = (float)(sfst[i].st_size - headersize[i])
		 /(float)sfclass(&sfdesc[i])/(float)sfchans(&sfdesc[i])
		 /sfsrate(&sfdesc[i]);
	return(dur);
}
double _peak(p,n_args)
float *p;
{
	char *cp,*getsfcode();
	int i,j;
	float peak;
	j = p[0];
	cp = getsfcode(&sfdesc[j],SF_MAXAMP);
	bcopy(cp + sizeof(SFCODE), (char *) &sfm[j], sizeof(SFMAXAMP));
	if(cp != NULL) {
		for(i=0,peak=0; i<sfchans(&sfdesc[j]); i++)
			if(sfmaxamp(&sfm[j],i) > peak) peak=sfmaxamp(&sfm[j],i);
		return(peak);
		}
	return(0.);
}
double _left(p,n_args)
float *p;
{
	char *cp,*getsfcode();
	int i,j;
	j = p[0];
	cp = getsfcode(&sfdesc[j],SF_MAXAMP);
	bcopy(cp + sizeof(SFCODE), (char *) &sfm[j], sizeof(SFMAXAMP));
	if(cp != NULL) 
		return(sfmaxamp(&sfm[j],0));
	return(0.);
}
double _right(p,n_args)
float *p;
{
	char *cp,*getsfcode();
	int i,j;
	j = p[0];
	if(sfchans(&sfdesc[j]) == 1) return(0);
	cp = getsfcode(&sfdesc[j],SF_MAXAMP);
	bcopy(cp + sizeof(SFCODE), (char *) &sfm[j], sizeof(SFMAXAMP));
	if(cp != NULL) 
		return(sfmaxamp(&sfm[j],1));
	return(0.);
}
