#import "Reson.h"
#import "../H/ugens.h"

extern float SR;

@implementation Reson : Object
{
	float a0,a1,a2,a3,a4;
}
+ create {
	id newInstance;
	newInstance = [ self new ];
	return newInstance;
}
- cf:(float)centerfreq bw:(float)bandwidth scl:(float)scale init:(int)initialize {
	 double exp(),cos(),sqrt();
        float c,temp;
        if(!initialize) { a4 = 0; a3 = 0;}
        a2 = exp(-PI2 * bandwidth/SR);
        temp = 1. - a2;
        c = a2+ 1;
        a1 = 4. * a2/c * cos(PI2 * centerfreq/SR);
        if(scale < 0) a0 = 1;
        if(scale) a0 = sqrt(temp/c*(c*c-a1*a1));
        if(!scale) a0 = temp*sqrt(1.-a1*a1/(4.*a2));
	return self;
}

- (float)bang: (float) sample {
	 float temp;
        temp = a0 * sample + a1 * a3  - a2 * a4;
        a4= a3;
        a3 = temp;
        return(temp);
	}
@end
