#include "../H/ugens.h"
#include "../H/sfheader.h"
#include "../macros/macros.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#define AMPTABLE 8192
extern SFHEADER      sfdesc[NFILES];

char *analysis;
float tablevals[3],amptablevals[3];
float amparray[AMPTABLE],pitchamparray[AMPTABLE];
float glissarray[AMPTABLE];
int fd,tablesize,pcurve;
float bot_freq,top_freq;

double slider(p,n_args)
float *p;

{
	/* p0=start, p1=dur, p2=pitch1, p3=pitch2 */

	int i,nsamps,len,risef,j,kontrol,wave,chans;
	int ipan,igliss,iwave,iamp;
	float one=1.0;
	float out[2],dur,psi,gsi,asi,si,*fwave,*fgliss,*famp,*fpan,pctlft,sig;
	float wtabs[4],gtabs[4],atabs[4],ptabs[4];
	float lo_pitch,hi_pitch,pitch,jpitch;
	float apitch,gpitch,ppitch;
	float lo_amp,hi_amp,amp;
	int wavelen,glisslen,amplen,panlen;
	float wphase,gphase,aphase,pphase,transp,thresh,pchanalamp;
	int output=1;

	j= out[1] = out[0] =wphase = gphase = aphase = pphase = 0;

	dur=p[1];
	tableset(p[1],tablesize,tablevals);
	tableset(p[1],AMPTABLE,amptablevals);
	
	if((p[2] < 20) && !pcurve) lo_pitch = octpch(p[2]);
	else if(pcurve) {
		if(p[2] <= 4.) lo_pitch = bot_freq * p[2]; 
		else lo_pitch=p[2];
		}
	else lo_pitch = p[2];
	
	if((p[3] < 20) && !pcurve) hi_pitch = octpch(p[3]);
	else if(pcurve) {
		if(p[3] <= 4.) hi_pitch = top_freq * p[3]; 
		else hi_pitch=p[3];
		}
	else hi_pitch = p[3];
	
	iwave=1;
	kontrol = SR/200;
	chans=sfchans(&sfdesc[output]);
	if(chans != 1) {
		printf("We want a MONO output file!\n");
		exit(-1);
		}
	fwave = floc(iwave);
	wavelen = fsize(iwave);
	gsi=kontrol*gpitch*glisslen/(SR*dur);
	nsamps = setnote(p[0],dur,output);
	transp = octpch(p[4]);
	thresh = p[5];
	
	for (i = 0; i < nsamps; i++) {
		while(!j--) {
			jpitch = tablei(i,glissarray,tablevals);
			pitch=lo_pitch + jpitch*(hi_pitch-lo_pitch);
			if(pcurve) {
				pitch=ABS((jpitch-bot_freq)/(top_freq-bot_freq)
				* (hi_pitch - lo_pitch) + lo_pitch);
				pitch =  cpsoct(octcps(pitch)+transp);
				}
			if((p[2] < 20) && !pcurve) pitch = cpsoct(pitch);
			si = pitch*wavelen/SR;
			amp = tablei(i,amparray,amptablevals);
			if(pcurve) {
			pchanalamp = tablei(i,pitchamparray,tablevals);
				if(pchanalamp > thresh) amp *= pchanalamp;
				else amp=0;
				}
			j=kontrol;
		}
		sig = oscili(amp,si,fwave,wavelen,&wphase);
		out[0] = sig;
		ADDOUT(out,output); 
	}
	endnote(output);
}
double wave(p,n_args)
float *p;
{	
	float array[256];
	int i;
	/* wave form will be gen array 1 */
	array[0] = 1;
	array[1] = 10;
	array[2] = 4096;
	for(i=3; i<256; i++) {
		if((i-3) == n_args) break;
		array[i] = p[i-3];
		}
	makegen(array,n_args+3);
}

double envelope(p,n_args)
float *p;
{
	int i;
	setline(p,n_args,AMPTABLE,amparray);
}		

double glissform(p,n_args)
float *p;
{
	int i;
	tablesize = AMPTABLE;
	pcurve = 0;
	setline(p,n_args,AMPTABLE,glissarray);
}		
double pitch_dataset(p,n_args)
float *p;
{
	int ii;
	ii = (int) p[0];
	analysis = (char *) ii;
	fd = fopen(analysis,"r");
	if(fd <= 0) {
		printf("cant open pitch analysis\n");
		closesf();
		}
}

double pitch_curve(p,n_args)
float *p;
{	
	int frame1,frame2,i,j,error;
	frame1 = p[0]; frame2 = p[1];
	error = fseek(fd,(frame1)*8,0);
	if(error < 0) {
		printf("bad seek on pitchdataset\n");
		closesf();
		}
	error = fread(glissarray,sizeof(float),(frame2-frame1+1)*2,fd);
	if(error < 0) {
		printf("bad read on pitchdataset\n");
		closesf();
		}
	bot_freq=999999; top_freq=-1;
	for(j=i=0; j<(frame2-frame1+1); i += 2,j++) {
		glissarray[j] = glissarray[i];
		if(glissarray[j] >= top_freq) top_freq=glissarray[j];
		if(glissarray[j] <= bot_freq) bot_freq=glissarray[j];

		pitchamparray[j] = glissarray[i+1];
	}
	tablesize = frame2-frame1+1;
	pcurve = 1;
	printf("bottom pitch = %f; top pitch = %f\n",bot_freq,top_freq);
}	

int NBYTES = 32768;
profile()
{
	UG_INTRO("slider",slider);
	UG_INTRO("wave",wave);
	UG_INTRO("envelope",envelope);
	UG_INTRO("glissform",glissform);
	UG_INTRO("play_frames",pitch_curve);
	UG_INTRO("pitch_dataset",pitch_dataset);
}
