// P.J.Leonard 18/7/97
// JTimer methods

#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <iostream.h>

#include "JTimer.h"
#include "JTimerClient.h"

// #define DEBUG

JTimerClient *         JTimer::_client=0;
JSysTime               JTimer::_start;
JTime                  JTimer::_timeStoped(0);
bool                   JTimer::_stoped=TRUE;

void  
JTimer::handler(int id) 
{ 
#ifdef DEBUG
  cerr << "JTimer::handler" << endl;
#endif

  if (_client != 0) _client->interuptHandler(id); 
}

void
JTimer::stop()
{
  if (_stoped) return;
  _timeStoped=timeNow();
  _stoped=TRUE;
}

void
JTimer::start()
{
  if (!_stoped) return;
  setNow(_timeStoped);
  _stoped=FALSE;
}


JTime 
JTimer::timeNow() 
{
  JSysTime t;
  if (_stoped) return _timeStoped;
  gettimeofday(&t,0);
  return t.timeFrom(_start);
}

void 
JTimer::setNow(const JTime &time)
{
  assert(_stoped);

  gettimeofday(&_start,0);
  _start.subtract(time);

  // if we are not running make sure we set correct time when we start.
  _timeStoped=time;
}

void
JTimer::setAlarmAt(const JTime &when)
{
  assert(!_stoped);

  if (_client == 0 ) return;

  JSysTime now;

  gettimeofday(&now,0);

#ifdef DEBUG
  cout << "when " << when <<  "start " << _start << " now "<< now << endl;
#endif

  JSysInterval dt(now,_start,when);

#ifdef DEBUG
  cout << "dt " << dt << endl;
#endif
  
  
  setitimer(ITIMER_REAL, &dt, 0);
  signal(SIGALRM,handler);

}








