#include "JPhraseSequencer.h"
#include "jam/JPhrase.h"

JPhraseSequencer::JPhraseSequencer(const JPhrase *phrase,JPlayer *player)
 :_beat(JBeat::endOfTime()),
  _phrase((JPhrase *)phrase),
  _player(player)
{
  _nextGesture = _phrase->gestureList()->head();
  if (_nextGesture == 0) _beat=JBeat::endOfTime();
  else _beat = _nextGesture->start(); 
}



JBeat
JPhraseSequencer::execute()
{


  JSequencer *seq=_sequencerList.first();

  assert(seq != 0);

  do {
    // Let the top sequencer execute until it reaches current time

    while( _beat >= seq->execute()) {;}

    // Remove sequencer or sort out the times
    if ( seq->nextBeat() == JBeat::endOfTime()) {
      _sequencerList.clearItem(seq,true);
    } else {
      _sequencerList.sortFirst();
    }

    // Look at the new top dog
    seq = _sequencerList.first();


    if (seq == 0) break;

  }  while( _beat >= seq->nextBeat() );   // --- carry on ?

  if (seq == 0) _beat=JBeat::endOfTime();
  else _beat = seq->nextBeat();

  // All the events on the que should be done now.
  // Prime the Q for the next go.

  loadGesturesBeforeBeat();

  return _beat;
}


JPhraseSequencer::~JPhraseSequencer()
{

  SDLLIterator <JSequencer>  iter(&_sequencerList);

  JSequencer *sequencer;

  while( ( sequencer = iter.next() ) != 0 ) {
    delete sequencer;
  }

}

void
JPhraseSequencer::loadGesturesBeforeBeat()
{

  if (_nextGesture != 0) {
    JSequencerList tList;
    while(_nextGesture->start() <= _beat ) {
      tList.prepend(_nextGesture->createSequencer(_player));
      _beat = _nextGesture->start();
      _nextGesture = _nextGesture->next();
      if (_nextGesture == 0) break;
    } 

    SDLLIterator<JSequencer> tIter(&tList);

    JSequencer *seq;

    while( (seq=tIter.next()) != 0) {
      _sequencerList.lowPriorityPrepend(seq);
    }
  }
}

JBeat 
JPhraseSequencer::gotoBeat(const JBeat &when)
{

//   SDLLIterator<JSequencer> list(&_sequencerList);

//   // Delete existing stuff
//   JSequencer *seq;
  
//   while( (seq=list.next()) != 0) {
//     delete seq;
//   }

  _sequencerList.clear(true);

  // Seek gesture list for when
  _nextGesture = _phrase->gestureList()->head();

  if (_nextGesture == 0 ) {
    _beat = JBeat::endOfTime();
    return _beat;
  }

  while (_nextGesture->start() <= when) {
    if (_nextGesture->end() > when) {
      _sequencerList.append(_nextGesture->createSequencer(_player));      
    }
    _nextGesture = _nextGesture->next();
    if (_nextGesture == 0) break;
  }

  JSequencer *seq=_sequencerList.first();

  if (seq == 0 ) {
    if (_nextGesture == 0) {
      _beat = JBeat::endOfTime();
      return _beat;
    } else {
      _beat=JBeat::endOfTime();
      loadGesturesBeforeBeat();
      return _beat;
    }
  }

  _beat = when;

  return _beat;
}














