#ifndef _JTrack_H
#define _JTrack_H

#include "JSequence.h"  // IS
#include "base/JName.h"
#include "rep/JStaveType.h"
#include "JPartList.h"
#include "base/JOSTemplate.h"
#include "JTrackUpdate.h"
#include "JHandle.h"

class JComposition;
class JPhraseUpdate;
class JMeter;
class JPlayer;
class JPhrase;
class JReader;

class JTrack : public JHandle,
	       public JSequence , 
	       public JName ,
	       public JObserver <JPhraseUpdate,void>,
	       public JSubject  <JTrackUpdate,void>
{
public:

  JTrack(JPlayer *voice,
	 JComposition *comp,
	 const char *name=0);
  
  
  virtual ~JTrack();

  JTrack *   clone();

  bool       display() const { return true; }

  JStaveType staveType() const { return TREBLE_STAVE; }

  JPlayer *  player() const { return _player;}

  bool       write(ostream &) const;
  bool       read(JReader &);

  void                 handle(JPhraseUpdate);
  JPhrase *            newPhrase(JPart *part=0);

  JPhraseList *        phraseList();
  const JPhraseList *  phraseList() const;

  JComposition *       composition() { return _composition; }
  const JComposition * composition() const { return _composition; }

  /// JSequence
  JSequencer *       createSequencer(JPlayer *)const;
  //  JNotator *         createNotator(JScorePainter *)const;

  JMeter *          meter();
  const JMeter *    meter() const;

  // TODO 
  //  JBeat  start()         const { return JBeat::startOfTime(); }
  // JBeat  end()           const { return JBeat::endOfTime(); }


protected:


  JComposition  *  _composition;
  JPhraseList      _phraseList;
  JPlayer *        _player;
  JTrackUpdate     _update;

};


//ostream & operator <<(ostream &,const JTrack &);

#endif







