#include "JPhraseController.h"
#include "JEvent.h"
#include "JPhrase.h"
//#include "JEffectNode.h"
//#include "JEffectList.h"
#include "JEffect.h"
#include "JPlayer.h"     // TO GET THE EFFECT LIST (hmmmm)
#include "JPhraseUpdate.h"

/*

 append a new event
 assert the current state at this new event

 */

JPhraseController::JPhraseController(JPhrase *phrase)
  :_phrase(phrase),
   _focus(0)
{

}


JGesture *
JPhraseController::seekFirst()
{
  _focus=0;
  return moveFocusRight();
}

/* PRIVATE */

// void
// JPhraseController::appendAfter(JGesture *before,
// 			       JGesture *newEvent)
// {
//   JGesture * after = before->next();
  
//   newEvent->setNext(after);
//   newEvent->setPrev(before);


//   before->_next = newEvent;
//   after->_prev  = newEvent;
// }


void
JPhraseController::updateFocus()
{
  if (_focus != 0) {
    _phrase->_update.contain(_focus->end());
    if (_focus->prev() != 0) {
      _phrase->_update.contain(_focus->prev()->start());
    } else {
      _phrase->_update.contain(_focus->start());
    }
  }
}

// const JEvent *
// JPhraseController::appendEvent(const JBeat &b,
// 				    JEffectType type,
// 				    int index,int value,
// 				    bool createNew)
// {

//   assert(createNew);

//   _phrase->_update.contain(b);

//   JEvent *newEvent = new JEvent(b,_phrase);
  
//   const JEvent *tail = _phrase->tail();
//   JEvent *prev = (JEvent *)(tail->prev());

//   appendAfter(prev,newEvent);

//   // get the event to add a node to the vertical list

//   JEffectNode * node = newEvent->addEffect(type,index,value,false);

  
//   // seek the head of the list and create if need be.

//   JEffectNode * headNode =
//     ((JEvent *)(_phrase->head()))->addEffect(type,
// 						   index,
// 						   UNSET_EFFECT_VALUE,true);
  
//   // horz list is cyclic so this is really the end !!!!

//   node->insertBefore(headNode);

//   return newEvent;
// }



// // PRIVATE //
// JEffectNode *
// JEventPhraseController::seekNodeAfter(const JBeat &b,JEffectNode *head)
// {
//   JEffectNode *node=head->right();

//   while( node != head ) {
//     JEvent *event = node->event();
//     assert( event != 0 );
//     if ( event->beat() > b ) return node;
//     node = node->right();
//   }
//   return head;
// }


void
JPhraseController::insertGesture(JGesture *g)
{
  _phrase->_update.contain(g->lrRep());
  _phrase->gestureList()->insert(g);
  //  _focus=g;
}


void
JPhraseController::detachFocus()
{
  updateFocus();
  _focus=0;
}

// void 
// JEventPhraseController::insertIntoHorz(JEffectNode *node)
// {

//   node->detachHorz();
  
//   JEffectNode * headNode = _phrase->head()->addEffect(node->type(),
// 						      node->index(),
// 						      UNSET_EFFECT_VALUE,
// 						      true);
//   // seek the correct time
    
//   JEffectNode *nodeAfter=seekNodeAfter(node->event()->beat(),headNode);
    
//   node->insertBefore(nodeAfter);
// }

// void 
// JEventPhraseController::rebuildEffects()
// {

//   damageFocus();

//   JEffectList * effectList=_phrase->player()->effectList();
  
//   if (effectList == 0) return;

//   JEffectListIterator effects(effectList);
//   JEffect * effect;

//   while( ( effect=effects.next()) != 0 )    {
//     if ( effect->on() ) {
//       _focus->addEffect(effect->type(),
// 			effect->index(),
// 			effect->value(),
// 			true);
//     } else {
//       JEffectNode *node = (JEffectNode *)_focus->seekEffect(effect->type(),
// 							   effect->index());
//       if (node != 0)  delete node;
//     }
//   }
// }

// void 
// JEventPhraseController::incrementEffect(JEffectType type)
// {
//   if (_focus == 0) return;

//   damageFocus();

//   JEffectNode *node = _focus->seekEffect(type);
//   node->setIndex(node->index()+1);

//   if (type == NOTE_EFFECT) {
//     JEffectNode *offNode = node->right();
//     offNode->setIndex(node->index());
//     insertIntoHorz(offNode);
//   }

//   insertIntoHorz(node);

// }

// void 
// JEventPhraseController::decrementEffect(JEffectType type)
// {
//   if (_focus == 0) return;
//   damageFocus();

//   JEffectNode *node = _focus->seekEffect(type);
//   node->setIndex(node->index()-1);
  
//   if (type == NOTE_EFFECT) {
//     JEffectNode *offNode = node->right();
//     assert(offNode != 0);
//     offNode->setIndex(node->index());
//     insertIntoHorz(offNode);
//   }

//   insertIntoHorz(node);
// }


void
JPhraseController::shiftRightOfBy(const JDuration &d)
{
  if (_focus == 0) return;

  updateFocus();

  // TODO this is a bit drastic

  _phrase->_update.contain(JBeat::endOfTime());

  JGestureListIterator iter(_focus);
  
  JGesture *event;
  while( (event=iter.next()) != 0 ) {
    event->shiftBy(d);
  }

  updateFocus();

}

JGesture *
JPhraseController::moveFocusRight()
{
  updateFocus();
  if (_focus == 0 ) {
    _focus = _phrase->gestureList()->head();
    updateFocus();
    return _focus;
  }

  _focus = _focus->next();

  updateFocus();

//   while( (_focus=_focus->next()) != 0 ) {
//     if (_focus->isTail()) {
//       _focus = 0;
//       break;
//     }

//     JEffectNode * node= _focus->seekEffect(NOTE_EFFECT);
//     if ( node == 0 ) continue;
//     if ( node->value() == 0 ) continue;
//     _focus=node->event();
//     damageFocus();
//     break;
//   }
  return _focus;
}


JGesture *
JPhraseController::moveFocusLeft()
{
  updateFocus();

  if (_focus == 0 ) {
    _focus = _phrase->gestureList()->tail();
    updateFocus();
    return _focus;
  }


  _focus = _focus->prev();

  updateFocus();
  return _focus;
}


JGesture *
JPhraseController::attachFocusAt(JBeat b)
{
  updateFocus();

  const JGesture *g;

  g = _phrase->gestureList()->head();
  
  if (g == 0) {
    _focus = 0;
    return _focus;
  }

  if (b <= g->start()) {
    _focus = (JGesture *)g;
    updateFocus();
    return _focus;
  }

  g =  _phrase->gestureList()->tail();

  if (b >= g->end()) {
    _focus =  (JGesture *)g;
    updateFocus();
    return _focus;
  }

  JGestureListIterator iter(_phrase->gestureList());

  while ( (g=iter.next()) != 0) {
    if (g->contains(b)) {
      _focus = (JGesture *)g;
      updateFocus();
      return _focus;
    } else if ( g->start() > b) {
      _focus = (JGesture *)g;
      updateFocus();
      return _focus;
    }
  }

  assert(0);
  return 0;
}


void 
JPhraseController::deleteFocus()
{

  if ( _focus == 0 ) return;

  updateFocus();

  JGesture * victim = _focus;

  moveFocusRight();

  _phrase->gestureList()->deleteGesture(victim);

  updateFocus();

}
  



