#include <string.h>
#include <iostream.h>
#include "JGestureList.h"
#include "JGestureFactory.h"
#include "rep/JReader.h"

JGestureList::JGestureList()
  :_head(0),
   _tail(0)
{

}

JGestureList::~JGestureList()
{
  // TODO memory leak hell

}

JGestureList *
JGestureList::clone()
{
  JGestureList *gl=new JGestureList;

  JGestureListIterator iter(this);

  JGesture *g;
  while( (g=iter.next()) != 0 ) {
    gl->append(g->clone());
  }
  return gl;

}

void 
JGestureList::deleteGesture(JGesture *g)
{
  if (_head == g) _head=g->_next;
  if (_tail == g) _tail=g->_prev;

  delete g;

}

bool 
JGestureList::write(ostream &out) const
{
  JGestureListIterator iter(this);

  JGesture *g;

  while( (g= iter.next()) != 0) {
    if (!g->write(out)) {
      cerr << " Error writing gesture type " << g->typeName() << endl;
      return false;
    }
    out << endl;
  }
  return true;
}


bool 
JGestureList::read(JReader &in)
{
  JGesture *g=0;
  

  char name[132];
  while(in.getString(name,132)) {
    if ( strncmp(name,"$End",4) == 0) return true;

    g = JGestureFactory::the()->createGesture(name);  
    
    if (g == 0 ) {
      cout << __FILE__ << __LINE__ << " unknown gesture name " << name << endl;
      return false;
    }
    
    g->read(in);
    append(g);
      
  }

  return true;
}


void 
JGestureList::append(JGesture *g)
{
  if (_tail == 0) {
    _tail = _head = g;
    return;
  }

  assert(g->_next == 0);

  _tail->_next = g;
  g->_prev     = _tail;
  _tail        = g;

}


void 
JGestureList::prepend(JGesture *g)
{
  if (_tail==0) {
    _tail = _head = g;
    return;
  }

  assert(g->_prev == 0);

  g->_next     = _head;
  _head->_prev = g;
  _head        = g;

}



void
JGestureList::insert(JGesture *g)
{
  if (_head == 0) {
    append(g);
    return;
  }


  JGesture * node=_head;

  assert(node != 0 );

  JBeat t = g->start();

  JBeat tNode;
  
  do {
    tNode = node->start();
    if ( tNode >= t ) {
      JGesture *prev=node->_prev;
      if (prev != 0) {
	prev->_next = g;
      } else {
	_head = g;
      }
      node->_prev = g;
      g->_next = node;
      g->_prev = prev;
      return;
    }
  }  while( (node=node->_next) != 0);
  
  append(g);
}



JGestureListIterator::JGestureListIterator(const JGestureList *list)
  :_next(list->_head)
{;}

JGestureListIterator::JGestureListIterator(JGesture *g)
  :_next(g)
{;}



JGesture *
JGestureListIterator::next()
{
  if (_next == 0) return 0;

  JGesture *ret=_next;
  _next = _next->_next;

  return ret;
}
 

JSequence *
JGestureListIterator::nextSequence()
{
  return next();
}
