#include "JEventPhraseBuilder.h"
#include "JError.h"
#include "JPhrase.h"
#include "JNoteGesture.h"
#include "JEffectEventGesture.h"

JEventPhraseBuilder::JEventPhraseBuilder(JPhrase *phrase)
  :_phrase(phrase),
   _beat(0)
{
  for (int i=0; i< 128 ; i++) {
    _on[i] = 0;
  }
}

JEventPhraseBuilder::~JEventPhraseBuilder()
{
  for (int i=0; i< 128 ; i++) {
    //    if (_on[i]  != 0) 
      //      warning("[JEventPhraseBuilder] note on without off \n");
  }
}

void
JEventPhraseBuilder::noteOnAt(JBeat b,int pitch,int vel)
{
  assert(pitch >= 0);
  assert(pitch < 128);

  if (vel == 0) {
    noteOffAt(b,pitch);
    return;
  }

  if (_on[pitch] != 0) {
    //    warning("[JEventPhraseBuilder] on follows on \n");
  } else {
    _on[pitch] =new JNoteGesture(b,
				 JDuration(0),
				 pitch,
				 vel);
    _phrase->appendGesture(_on[pitch]);
  }
}



void
JEventPhraseBuilder::noteOffAt(JBeat b,int pitch)
{
  assert(pitch >= 0);
  assert(pitch < 128);

  if (_on[pitch] == 0) {
    //    warning("[JEventPhraseBuilder] off but no on \n");
    return;
  }
  
  JDuration d = b - _on[pitch]->start();
  _on[pitch]->setDuration(d);
  _on[pitch] = 0;
}

void
JEventPhraseBuilder::appendEventAt(JBeat b,
				   JMidiOutType type,
				   int index,
				   int val)
{
  assert(b >= _beat);

  _beat=b;

  if (type == JMidiOutType::NOTE_EFFECT) {
    if ( val == 0 ) {
      noteOffAt(b,index);
    } else {
      noteOnAt(b,index,val);
    }
    return;
  }

  _phrase->appendGesture(new JEffectEventGesture(b,
						 JMidiOutEvent(type,index,val)));
}




