#include "JMetaSequencer.h"
#include "jam/JTrackList.h"


// Default MetaSequencer is a simple beast.


JMetaSequencer::JMetaSequencer()
  :_beat(JBeat::endOfTime())
{

}

JMetaSequencer::JMetaSequencer(JSequenceListIterator &iter,JPlayer *player)
  :_beat(JBeat::endOfTime())
{

  JSequence *sequence;

  while( ( sequence = iter.nextSequence() ) != 0 ) {
    //    if (!sequence->active()) continue;
    JSequencer *seq=sequence->createSequencer(player);
    if (seq == 0) continue;
    _sequencerList.add(seq);
    if (_beat > seq->nextBeat()) {
      _beat=seq->nextBeat();
    }
  }
}





JBeat
JMetaSequencer::execute()
{

  // Do all events up to my current _beat
  // _beat is set to beat of next event.
  // Make sure that gotoBeat has been called before this !!!

  if (_beat == JBeat::endOfTime()) return _beat;

  JBeat tNext;
  JSequencer *seq=_sequencerList.first();
  assert(seq != 0);
  do {
    while( _beat >= seq->execute());
    
      // --- sort out the priority ---
    _sequencerList.sortFirst();
    seq=_sequencerList.first();
    
  }  while(_beat >= (tNext=seq->nextBeat()));   // --- carry on ?

  _beat=tNext;
  return _beat;
}


JMetaSequencer::~JMetaSequencer()
{
  SDLLIterator <JSequencer>  iter(&_sequencerList);

  JSequencer *sequencer;

  while( ( sequencer = iter.next() ) != 0 ) {
    delete sequencer;
  }
}


JBeat 
JMetaSequencer::gotoBeat(const JBeat &when)
{

  SDLLIterator<JSequencer> list(&_sequencerList);

  JSequencer *seq;
  
  while( (seq=list.next()) != 0) {
    seq->gotoBeat(when);
  }

  _sequencerList.sortAll();

  JSequencer *top = _sequencerList.first();

  if (top == 0 )
    _beat=JBeat::endOfTime();
  else
    _beat=top->nextBeat();

  return _beat;
}








