#ifndef _QJPixDraw_H
#define _QJPixDraw_H

#include <qbitmap.h>
#include "QJDraw.h"

/**
 * QJPixDraw manages all objects that are stored as bitmaps.
 * The Bitmaps are kept within the instance of the class, and copied as needed
 * to an external paint device using a QPainter. 
 * This means that an object can be created once, and used many times in 
 * different locations */

class QJPixDraw: public QJDraw
{
public:
   ///constructor that is user for objects that are to be drawn with a QPainter
   QJPixDraw(int,int);
   ///constructor used for bitmaps that are loaded from disk.
   QJPixDraw(char *);
   ///constructior used for bitmaps that are included in the source.
   QJPixDraw(int, int, char*, bool);
   
   /**Copy the internal bitmap to another paintdevice using the QPainter
    * specified at the co-ordinates given on the target device. */
   void draw(int ,int ,QPainter *) const;

   ///Return a reference to the bitmap.
   QBitmap* bitmap() { return &_bitmap; }
   ///(Inline function) Return the bounding box (dimansions) of the object.
  const QRect *bBox() const {return(&_bitmap.rect());}
  int x() const {return(0);}
  int y() const {return(0);}
  int width()const {return(_bitmap.width());}
  int height() const{return(_bitmap.height());}

 protected:
   /**internal bitmap on which the object is stored. */
   QBitmap _bitmap;
};

#endif








