#ifndef _QJPhraseEditor_H
#define _QJPhraseEditor_H

/*!
  \class JEventPhraseEditor JEventPhraseEditor.h
  \brief Command driven JEventPhrase Editor
*/

#include "base/JOSTemplate.h"
#include "rep/JMidiOutEvent.h"

#include "QJEditor.h"


class JPhrase;
class JPhraseController;
class JConductor;
class JBeat;
class JCursor;
class JFocus;
class JDurationTool;
class JContext;
class JVoice;
class JGesture;

class QJPhraseEditor: public QJEditor,
		      public JObserver<JMidiOutEvent,void>
{
 Q_OBJECT
public:
  QJPhraseEditor(JContext *);
  virtual ~QJPhraseEditor();

  State setContext();
  void  handle(JMidiOutEvent e);

  const char * name() const { return "PhraseEditor";}

public slots:

  void insert();
  void metainsert();
  void up();
  void down();
  void metaup();
  void metadown();

  void left();
  void right();

  void space();
  void backspace();
  void enter();
  void escape();
  void del();
  void keyPress(QKeyEvent *e);

protected:

  void playFocus();
  void playGesture(JGesture *);


private:

  void update();

  JPhrase *             _phrase;
  JContext *            _context;
  int                   _iTweak;
  int                   _onCount;

};


#endif



