#include "QJListDraw.h"
#include "assert.h"
#include <qrect.h>
#include <qpainter.h>

QJListDraw::QJListDraw(int n)
{
  _n=n;
  _qjDraw=new const QJDraw*[n];
  _x=new int[n];
  _y=new int[n];
  _bBox=new QRect(0,0,0,0);
  for(int i=0;i<n;i++) {
    _qjDraw[i]=0;
  }
}

QJListDraw::~QJListDraw()
{
  delete _bBox;
  delete [] _y;
  delete [] _x;
  delete [] _qjDraw;
}




void QJListDraw::add(int index,const QJDraw *qjDraw,int x,int y)
{
  assert(index>=0 && index < _n);
  _qjDraw[index]=qjDraw;
  _x[index]=x;
  _y[index]=y;

  QRect r=*(qjDraw->bBox());
  r.moveBy(x,y);

  if (!r.isValid()) {
    debug(" QJListDraw invalid rect !!!! ");
  }

  if (!_bBox->isValid())
    {
      *_bBox=r;
      return;
    }

  ///  debug(" BEFORE: %d %d %d %d ",_bBox->x(),_bBox->y(),_bBox->width(),_bBox->height());


  ///  debug("%d %d %d %d ",r.x(),r.y(),r.width(),r.height());  
  
  //  QRect b=*_bBox;
  //   r.setX(x+r.x());
  //   r.setY(y+r.y());

  *_bBox = _bBox->unite(r);  

  /// debug("AFTER: %d %d %d %d ",_bBox->x(),_bBox->y(),_bBox->width(),_bBox->height());
}

// void QJListDraw::draw(int dx,int dy,QPaintDevice * host){
//   for (int i=0;i<_n;i++) {
//     if (_qjDraw[i]!=0) {
//       _qjDraw[i]->draw(_x[i]+dx,_y[i]+dy,host);
//     }
//   }
// }


void QJListDraw::draw(int dx,int dy,QPainter * host) const
{
  for (int i=0;i<_n;i++) {
    if (_qjDraw[i]!=0) {
      _qjDraw[i]->draw(_x[i]+dx,_y[i]+dy,host);
    }
  }
  ///  host->drawRect(_bBox->x()+dx,_bBox->y()+dy,_bBox->width(),_bBox->height());
}



const QRect* QJListDraw::bBox() const{
  return(_bBox);
}

int QJListDraw::x() const{
  return(_bBox->x());
}

int QJListDraw::y() const{
  return(_bBox->y());
}

int QJListDraw::width() const{
  return(_bBox->width());
}

int QJListDraw::height() const{
  return(_bBox->height());
}











