#include "QJDefaultDeviceCommand.h"
#include "jam/JDeviceManager.h"
#include "jam/JDevice.h"
#include "jam/JVoiceManager.h"


#include <qlistbox.h>
#include <qcombo.h>




void
QJDefaultDeviceCommand::execute()
{

  QComboBox *listBox = new QComboBox();
  
  JDeviceManager *dm = JDeviceManager::the();

  for (int i = 0 ; i < dm->nOutDevice() ; i++) {
    JDevice *device = dm->outDevice(i);
    listBox->insertItem(device->name(),i);
  }

  listBox->setCurrentItem(JVoiceManager::the()->defaultDevice());
  //  connect(listBox,SIGNAL(selected(int)),SLOT(setDefault(int)));
  connect(listBox,SIGNAL(highlighted(int)),SLOT(setDefault(int)));

  listBox->adjustSize();
  listBox->show();

}


void 
QJDefaultDeviceCommand::setDefault(int i)
{
  JVoiceManager::the()->setDefaultDevice(i);
}




