#include "JAweDevice.h"
#include "jam/JEffect.h"
#include "jam/JEffectList.h"
#include "rep/JMidiType.h"

#include <linux/awe_voice.h>
#include "rep/JMidiDefines.h"

#include <values.h>
#include <stdio.h>

JAweDevice::JAweDevice(int devId) 
  :JOSSDevice(devId,"AWE")
{

}


JAweDevice::~JAweDevice()
{

}



JEffectList *
JAweDevice::createEffectList()
{

  JEffectList *effectList=JOSSDevice::createEffectList();

//   effectList->add(new JOSSSynthControllerEffect(CTL_MODWHEEL,0,127,"Modulation",rep),true);

//   JEffect *e=new JOSSSynthProgramEffect(rep);
//   channel->setProgram(e);
//   effectList->add(e,true);


//   effectList->add(new JOSSSynthControllerEffect(CTL_BANK_SELECT,0,128,"Bank",rep),true);

//   effectList->add(new JOSSSynthControllerEffect(CTL_EXPRESSION,0,127,"Expression",rep),true);

//   effectList->add(new JOSSSynthControllerEffect(CTL_MAIN_VOLUME,0,127,"Volume",rep),true);


//   effectList->add(new JOSSSynthControllerEffect(CTL_BALANCE,0,127,"Balance",rep),true);

//   effectList->add(new JOSSSynthControllerEffect(CTL_PAN,0,127,"Pan",rep),true);


//   effectList->add(new JOSSSynthControllerEffect(CTL_SUSTAIN,0,127, "Sustain",rep),true);


//   effectList->add(new JOSSSynthControllerEffect(CTL_EXT_EFF_DEPTH,0,127,"Reverb",rep),true);

//   effectList->add(new JOSSSynthControllerEffect(CTL_CHORUS_DEPTH,0,127, "Chorus",rep),true);

//   e=new JOSSSynthPitchBendEffect(rep);
//   channel->setPitchBend(e);
//   effectList->add(e,true);


// //   channel->setAllNoteOff(new JOSSSynthControllerEffect(CTL_CHORUS_DEPTH,0,127, "Chorus",rep),true);
// //   e=new JMessageEffect("SEQRESET");
// //   channel->setReset(e);       

//   for (int i=0 ; i < 128 ; i++ ){
//     channel->setNote(i,new JOSSSynthNoteEffect(i,rep));
//   }


  //**********************************************************************
  
//   channel->setReset(new JAweResetEffect(rep));
//   channel->setAllNoteOff(new JAweAllNoteOffEffect(rep));
  
  
  //   /* modulation envelope parameters */
  //   /* 0*/	AWE_FX_ENV1_DELAY,	/* WORD: ENVVAL */
  //   /* 1*/	AWE_FX_ENV1_ATTACK,	/* BYTE: up ATKHLD */
  //   /* 2*/	AWE_FX_ENV1_HOLD,	/* BYTE: lw ATKHLD */
  //   /* 3*/	AWE_FX_ENV1_DECAY,	/* BYTE: lw DCYSUS */
  //   /* 4*/	AWE_FX_ENV1_RELEASE,	/* BYTE: lw DCYSUS */
  //   /* 5*/	AWE_FX_ENV1_SUSTAIN,	/* BYTE: up DCYSUS */
  //   /* 6*/	AWE_FX_ENV1_PITCH,	/* BYTE: up PEFE */
  //   /* 7*/	AWE_FX_ENV1_CUTOFF,	/* BYTE: lw PEFE */
  

#define ADD_AWE_EFFECT(t,minV,maxV,name) \
  effectList->add(new JEffect(minV,maxV,JMidiOutType::AUX_EFFECT,t,name),true);
  
  ADD_AWE_EFFECT(AWE_FX_ENV1_DELAY,0,5900,"Delay_1");
  
  ADD_AWE_EFFECT(AWE_FX_ENV1_ATTACK,0,5940,"Attack_1");
  
  ADD_AWE_EFFECT(AWE_FX_ENV1_HOLD,0,8191,"Hold_1");
  
  ADD_AWE_EFFECT(AWE_FX_ENV1_DECAY,0,5940,"Decay_1");
			     
  ADD_AWE_EFFECT(AWE_FX_ENV1_RELEASE,0,5490,"Release_1");

  ADD_AWE_EFFECT(AWE_FX_ENV1_SUSTAIN,0,127,"Sustain_1");

  ADD_AWE_EFFECT(AWE_FX_ENV1_PITCH,-127,127,"Pitch_1");

  ADD_AWE_EFFECT(AWE_FX_ENV1_CUTOFF,-64,63,"Cutoff_1");


  //    volume envelope parameters 
  //    8	AWE_FX_ENV2_DELAY,	/* WORD: ENVVOL */
  //    9	AWE_FX_ENV2_ATTACK,	/* BYTE: up ATKHLDV */
  //   10	AWE_FX_ENV2_HOLD,	/* BYTE: lw ATKHLDV */
  //   11	AWE_FX_ENV2_DECAY,	/* BYTE: lw DCYSUSV */
  //   12	AWE_FX_ENV2_RELEASE,	/* BYTE: lw DCYSUSV */
  //   13	AWE_FX_ENV2_SUSTAIN,	/* BYTE: up DCYSUSV */

  ADD_AWE_EFFECT(AWE_FX_ENV2_DELAY,0,5900,"Delay_2");

  ADD_AWE_EFFECT(AWE_FX_ENV2_ATTACK,0,5940,"Attack_2");

  ADD_AWE_EFFECT(AWE_FX_ENV2_HOLD,0,8191,"Hold_2");

  ADD_AWE_EFFECT(AWE_FX_ENV2_DECAY,0,5940,"Decay_2");

  ADD_AWE_EFFECT(AWE_FX_ENV2_RELEASE,0,5940,"Release_2");

  ADD_AWE_EFFECT(AWE_FX_ENV2_SUSTAIN,0,127,"Sustain_2");
	
//   /* LFO1 (tremolo & vibrato) parameters */
//   /*14*/	AWE_FX_LFO1_DELAY,	/* WORD: LFO1VAL */
// 		  /*15*/	AWE_FX_LFO1_FREQ,	/* BYTE: lo TREMFRQ */
// 		  /*16*/	AWE_FX_LFO1_VOLUME,	/* BYTE: up TREMFRQ */
// 		  /*17*/	AWE_FX_LFO1_PITCH,	/* BYTE: up FMMOD */
// 		  /*18*/	AWE_FX_LFO1_CUTOFF,	/* BYTE: lo FMMOD */

  ADD_AWE_EFFECT(AWE_FX_LFO1_DELAY,0,5900,"LFO1 Delay");

  ADD_AWE_EFFECT(AWE_FX_LFO1_FREQ,0,127,"LFO1 freq");

  ADD_AWE_EFFECT(AWE_FX_LFO1_VOLUME,0,127,"LFO1 vol");

  ADD_AWE_EFFECT(AWE_FX_LFO1_PITCH,-127,127,"LFO1 pitch");

  ADD_AWE_EFFECT(AWE_FX_LFO1_CUTOFF,-64,63,"LFO1 cutoff");

//   /* LFO2 (vibrato) parameters */
//   /*19*/	AWE_FX_LFO2_DELAY,	/* WORD: LFO2VAL */
// 		  /*20*/	AWE_FX_LFO2_FREQ,	/* BYTE: lo FM2FRQ2 */
// 		  /*21*/	AWE_FX_LFO2_PITCH,	/* BYTE: up FM2FRQ2 */

  ADD_AWE_EFFECT(AWE_FX_LFO2_DELAY,0,5900,"LFO2 Delay");

  ADD_AWE_EFFECT(AWE_FX_LFO2_FREQ,0,127,"LFO2 Freq");

  ADD_AWE_EFFECT(AWE_FX_LFO2_PITCH,-127,127,"LFO2 Pitch");


//   Other overall effect parameters 
//  22	AWE_FX_INIT_PITCH,	/* SHORT: pitch offset */
//  23	AWE_FX_CHORUS,		/* BYTE: chorus effects send (0-255) */
//  24	AWE_FX_REVERB,		/* BYTE: reverb effects send (0-255) */
//  25	AWE_FX_CUTOFF,		/* BYTE: up IFATN */
//  26	AWE_FX_FILTERQ,		/* BYTE: up CCCA */

  ADD_AWE_EFFECT(AWE_FX_INIT_PITCH,-8192,8192,"Pitch");
  
  ADD_AWE_EFFECT(AWE_FX_CHORUS,0,255,"Chorus");
  
  ADD_AWE_EFFECT(AWE_FX_REVERB,0,255,"Reverb");		
  
  
  ADD_AWE_EFFECT(AWE_FX_CUTOFF,0,127,"Wah");

  ADD_AWE_EFFECT(AWE_FX_FILTERQ,0,127,"Q");
  
//  Sample / loop offset changes */
// 27	AWE_FX_SAMPLE_START,	/* SHORT: offset */
// 28	AWE_FX_LOOP_START,	/* SHORT: offset */
// 29	AWE_FX_LOOP_END,	/* SHORT: offset */
// 30	AWE_FX_COARSE_SAMPLE_START,	/* SHORT: upper word offset */
// 31	AWE_FX_COARSE_LOOP_START,	/* SHORT: upper word offset */
// 32	AWE_FX_COARSE_LOOP_END,		/* SHORT: upper word offset */

#if 0
  ADD_AWE_EFFECT(AWE_FX_SAMPLE_START,MINSHORT,MAXSHORT,"Sample start"),true);
  
  
  ADD_AWE_EFFECT(AWE_FX_LOOP_START,MINSHORT,MAXSHORT,"Loop start");
  
  ADD_AWE_EFFECT(AWE_FX_LOOP_END,MINSHORT,MAXSHORT,"Loop end");
  
  ADD_AWE_EFFECT(AWE_FX_COARSE_SAMPLE_START,MINSHORT,MAXSHORT,"Start[hi]");
  
  ADD_AWE_EFFECT(AWE_FX_COARSE_LOOP_START,MINSHORT,MAXSHORT,"Loop start[Hi]");
  
  ADD_AWE_EFFECT(AWE_FX_COARSE_LOOP_END,MINSHORT,MAXSHORT,"LOOP END [Hi]");
#endif

  return effectList;
}





