#include <string.h> // strncmp strlen
#include "JVoiceManager.h"
#include "JConductor.h"
#include "JDeviceManager.h"
#include "JMapper.h"
#include "JVoice.h"
#include "JDevice.h"

JVoiceManager * JVoiceManager::_the=0;

JVoiceManager::JVoiceManager()
  :_defaultDevice(0),
   _conductor(0)
{
  assert(_the == 0);
  _the = this;
}


JVoiceManager *
JVoiceManager::the()
{
  if (_the == 0 ) _the = new JVoiceManager();
  return _the;
}


JVoice *
JVoiceManager::defaultVoice()
{
  JVoice *voice=_voiceList.first();
  if ( voice == 0) {
    voice = newVoice("VOICE");
  }

  return voice;

}

JVoice *
JVoiceManager::newVoice(const char *name)
{

  int devId = _defaultDevice;
  for(int i=0; i< JDeviceManager::the()->nOutDevice() ; i++) {
    int nChar = strlen(JDeviceManager::the()->outDevice(i)->name());
    if (strncmp(name,JDeviceManager::the()->outDevice(i)->name(),nChar) == 0) {
      devId = i ;
    }
  }

  JMapper *mapper = new JMapper();
  
  JVoice *voice = new JVoice(mapper,JDeviceManager::the(),name);

  voice->setDeviceId(devId);
  _voiceList.add(voice,false);
 

  if ( _conductor != 0 ) _conductor->attach(voice);
  return voice;
}











