#ifdef J_DEBUG
#include <iostream.h>
#endif

#include "JVoice.h"
#include "rep/JMidiInEvent.h"
#include "command/JPlayerCommand.h"
#include "rep/JMidiOutEvent.h"
#include "base/JList.h"
#include "JMapper.h"
#include "JVertIterator.h"
#include "JEvent.h"
#include "JMidiOut.h"
#include "rep/JMidiDefines.h"
#include "JEffectList.h"
#include "JDevice.h"
#include "JDeviceManager.h"

JVoice::JVoice(JMapper *mapper,JMidiOut *midiOut,const char *name)
  : JName(name),
    _monitor(0),
    _midiOut(midiOut),
    _mapper(mapper),
    _prog(0),
    _bank(0),
    _devId(0),
    _chnId(0),
    _effectList(0),
    _mute(false)
{


}

JVoice::~JVoice()
{

}

int               
JVoice::channelId() const
{
  return _chnId;
} 

int               
JVoice::deviceId() const
{
  return _devId;
} 

void 
JVoice::setChannelId(int id)
{
  _chnId=id;
}
  


int
JVoice::programId() const
{
  return _prog;
}


int
JVoice::bankId() const
{
  return _bank;
}


void 
JVoice::setDeviceId(int id)
{

 _devId=id;
 if (_effectList != 0) {
   delete _effectList;
 }

 _effectList = JDeviceManager::the()->newDeviceEffectList(_devId);

 notifyObservers(JVoiceUpdate());
}

const char *
JVoice::defaultDeviceName() const
{
  JDevice * dev = JDeviceManager::the()->outDevice(_devId);
  return dev->name();
}

void 
JVoice::setProgramId(int prog)
{
  _prog=prog;
  resetVoice();

}

void 
JVoice::setBankId(int bank)
{
  _bank=bank;
  resetVoice();
}


void
JVoice::resetVoice()
{
 handle(JMidiOutEvent(JMidiOutType::PROGRAM_EFFECT,0,_prog));
 handle(JMidiOutEvent(JMidiOutType::CNTRL_EFFECT,CTL_BANK_SELECT,_bank));
}

void
JVoice::setMonitor(JMidiOut *monitor)
{
  _monitor = monitor;
}


JEffectList *
JVoice::effectList()
{
 return _effectList;

//  if (_mapper == 0 ) return 0;
//  return _mapper->channel()->effectList();

}

void
JVoice::handle(JPlayerCommand command)
{

  switch(command.type()) {

  case JPlayerCommand::SILENT:
    	
    handle(JMidiOutEvent(JMidiOutType::ALLNOTEOFF_EFFECT));
    break;
    
  default:
    break;
  }
}



void
JVoice::handle(JMidiInEvent event)
{

  JMidiOutEvent outEvent=_mapper->translateEvent(event);
  if (_monitor != 0) _monitor->handle(outEvent);
  handle(outEvent);
}



void
JVoice::handle(JMidiOutEvent event)
{
  if (_mute) return;
  if (_midiOut != 0) {
    event.setChannelId(_chnId);
    event.setDeviceId(_devId);
    _midiOut->handle(event);
  }
}









