#ifndef _JMeter_H
#define _JMeter_H

/*!
  \class JMeterTrack JMeterTrack.h
  \brief reponsible for tempo and time sig changes (bars)


*/

#include "JToBPT.h"

class JMeter;
class JBarIterator;
class JToBBT;
class JComposition;
class JNotation;
class JNotator;
class JScorePainter;

class JMeter : public JToBPT // ,public JSequence  // , public JTrack
{
public:

  JMeter(const char *name="MeterTrack");
  ~JMeter();

  //  JNotator     * createNotator(JScorePainter *) const;

  JBarIterator * createBarIterator(const JBeat &from,
				   const JBeat &till) const;

  int      pulsesInBar(int)    const        { return 4; }
  JBeat    beatAtBar(int bar) const         { return JBeat(4*bar); }
  int      barContaining(JBeat beat) const  { return (int)(beat.rep()/4); }
  int      ticksInPulse()  const            { return 360; }               
  const char *name() const { return "Meter"; }
protected:

//  JEventPhrase * _tempoChangeList;

};


#endif







