#include "JGroovePhraseBuilder.h"
#include "JGroove.h"
#include "JRecordEvent.h"
#include "JRecordEventList.h"
#include "JPhrase.h"
#include "JEventPhraseBuilder.h"
#include "JDLL.h"

JGroovePhraseBuilder::JGroovePhraseBuilder(JGroove *groove,
					   JPhrase *phrase)
  :_groove(groove),
   _builder(0)
{
  _builder = new JEventPhraseBuilder(phrase);
}

JGroovePhraseBuilder::~JGroovePhraseBuilder()
{
  delete _builder;
}

void  
JGroovePhraseBuilder::buildPhrase(JRecordEventList *in)
{
  JDLLIterator<JRecordEvent> iter(in);

  JRecordEvent *inEvent;
  while ( (inEvent=iter.next()) != 0 ) {
    appendRecordEvent(inEvent);
  }
}


void
JGroovePhraseBuilder::appendRecordEvent(JRecordEvent *event)
{

  JBeat beat=_groove->beat(event->beat());
  // assert(0);
  _builder->appendEventAt(beat,event->type(),event->index(),event->value());
}













