#ifndef _JEffect_H
#define _JEffect_H

/*!
 \class JEffect JEffect.h
 \brief base class for device interface components.

*/

#include "JIntRange.h"    
#include "assert.h"
#include "base/JName.h"   
#include "rep/JMidiType.h"
#include "rep/JMidiOutEvent.h"

class JEffect : public JIntRange, 
		public JMidiOutEvent,
		public JName
{
public:

  JEffect(int minValue,
	  int maxValue,
	  JMidiOutType type,
	  int index,
	  const char *name)
    :JIntRange(minValue,maxValue),JMidiOutEvent(type,index,0),JName(name),
    _on(false)
    {}

  virtual ~JEffect(){;}

  bool                on() const { return _on; }
  void                setOn(bool on) { _on=on; }

protected:

  bool                 _on;

};


#endif





