#ifndef _JCursor_H
#define _JCursor_H

#include "base/JOSTemplate.h"
#include "rep/JBeat.h"


class JCursor:public JSubject<const JCursor *,void>
{

public:
  JCursor();
  virtual ~JCursor();

  const char * name() const { return "Cursor"; }

  //  static JCursor *the();

  void decPitch();
  void incPitch();
  void moveLeftBy(const JDuration &duration);
  void moveRightBy(const JDuration &duration);
  void touchState();

  void  setPitch(int pitch); 
  int   pitch() const { return _pitch; }
  void  setBeat(const JBeat &beat);

  void  show() { _damaged = _damaged || (!_visible) ; _visible=true; }
  void  hide() { _damaged = _damaged || (_visible) ; _visible=false; }

  bool  isVisible() const { return _visible; }

  const JBeat &beat() const  { return _beat;}
  void  update();

protected:
  
  //  static JCursor *   _the;
  JBeat              _beat;
  int                _pitch;
  bool               _visible;
  bool               _damaged;
};


#endif
