#include "JContext.h"
#include "../jam/JComposition.h"
#include "../jam/JFocus.h"
#include "JConductor.h"
#include "../jam/JBPT.h"
#include "../jam/JMeter.h"
#include "JDurationTool.h"
#include "JVoiceRecorder.h"
#include "JCursor.h"

JContext::JContext(const char *name)
{

  _composition = new JComposition(name);
  _meter       = new JMeter();
  _cursor      = new JCursor;
  _focus       = new JFocus(_composition);
  _conductor   = new JConductor(_composition);
  _left        = new JBPT(_meter,"left");
  _right       = new JBPT(_meter,"right");
  _time        = new JBPT(_meter,"time");

  _left->setBeat(_conductor->left());
  _right->setBeat(_conductor->right());

  _duration   = new JDurationTool();
  _voiceRec   = new JVoiceRecorder(this);


  //  _conductor->attach(_voiceRec);

}


JContext::~JContext()
{
  delete _voiceRec;
  delete _duration;
  delete _time;
  delete _right;
  delete _left;
  delete _focus;
  delete _cursor;
  delete _conductor;
  delete _composition;
}

