#include "JStaveNoteInfo.h"

JStaveNoteInfo::JStaveNoteInfo(int line,
				 JAccidental accidental, 
				 int start,
				 int end)
{
  _line=line;
  _accidental=accidental;
  _startLadder=start;
  _endLadder=end;
}

// bool        
// JStaveNoteInfo::up() const 
// {
//   return _up;
// }


// bool        
// JStaveNoteInfo::onRung() const
// {
//   return (_NoteY == _startLadder) || (_NoteY == _endLadder);

// }


int        
JStaveNoteInfo::nRungs() const
{
  
  if (_startLadder > _endLadder) return 0;
  
  return (_endLadder-_startLadder)/2 + 1;
}

int 
JStaveNoteInfo::line() const
{
  return(_line);
}

JAccidental 
JStaveNoteInfo::accidental() const
{
  return(_accidental);
}

int 
JStaveNoteInfo::startLadder() const
{
  return(_startLadder);
}

int 
JStaveNoteInfo::endLadder() const
{
  return(_endLadder);
}
