#include "JStave.h"
#include "JKey.h"
#include "JScale.h"
#include "JStaveNoteInfo.h"
#include "JAccidental.h"
#include "assert.h"

JStave::JStave(JStaveType type)
  :_type(type)
{
  
  int firstPitch=64;

  switch (type){
  case TREBLE_STAVE:
    _nLines=5;
    firstPitch=64;
    break;
  case BASS_STAVE: 
  case ALTO_STAVE:    //etc.
  default:
    _nLines=5;
    firstPitch=64;
    break;
  }
  loadStaff();

  _firstLine=_map[firstPitch][0];

}

int 
JStave::nLines() const
{
  return(_nLines);
}

int 
JStave::firstLine() const
{
  return(_firstLine);
}

JStaveNoteInfo 
JStave::staveNoteInfo(int pitch) const
{
  JAccidental accidental=NONE;
  int tempY=0;
  int startLadder=1;
  int endLadder=-1;

  tempY=_map[pitch][0]; //which line on the staff
  accidental=(JAccidental) _map[pitch][2];  //current accidental

  
  if (tempY < (_firstLine-1) )
    {
      startLadder =  tempY  + (_firstLine-tempY)%2;
      endLadder   = _firstLine - 2;
    }
  else if (tempY > ( _firstLine+(_nLines-1)*2 +1) )
    {
      endLadder   =  tempY   - (tempY-_firstLine)%2;
      startLadder =  _firstLine + _nLines*2 ;
    }
    
  return(JStaveNoteInfo(tempY,accidental,startLadder,endLadder));

}

void JStave::loadStaff(){
  int line;
  for (int i=0;i<11;i++){
    line=0;
    //'LINE' NUMBERS
    _map[(i*12)][0]=(i*7);
    _map[(i*12)+1][0]=(i*7);
    _map[(i*12)+2][0]=(i*7)+1;
    _map[(i*12)+3][0]=(i*7)+1;
    _map[(i*12)+4][0]=(i*7)+2;
    _map[(i*12)+5][0]=(i*7)+3;
    _map[(i*12)+6][0]=(i*7)+3;
    _map[(i*12)+7][0]=(i*7)+4;
    if (i<10){
      _map[(i*12)+8][0]=(i*7)+4;
      _map[(i*12)+9][0]=(i*7)+5;
      _map[(i*12)+10][0]=(i*7)+5;
      _map[(i*12)+11][0]=(i*7)+6;
    }

    //Default Accidentals

    _map[(i*12)][1]=NONE;
    _map[(i*12)+1][1]=SHARP;
    _map[(i*12)+2][1]=NONE;
    _map[(i*12)+3][1]=SHARP;
    _map[(i*12)+4][1]=NONE;
    _map[(i*12)+5][1]=NONE;
    _map[(i*12)+6][1]=SHARP;
    _map[(i*12)+7][1]=NONE;
    if (i<10){
      _map[(i*12)+8][1]=SHARP;
      _map[(i*12)+9][1]=NONE;
      _map[(i*12)+10][1]=SHARP;
      _map[(i*12)+11][1]=NONE;
    }

    //Current accidentals

    _map[(i*12)][2]=NONE;
    _map[(i*12)+1][2]=SHARP;
    _map[(i*12)+2][2]=NONE;
    _map[(i*12)+3][2]=SHARP;
    _map[(i*12)+4][2]=NONE;
    _map[(i*12)+5][2]=NONE;
    _map[(i*12)+6][2]=SHARP;
    _map[(i*12)+7][2]=NONE;
    if (i<10){
      _map[(i*12)+8][2]=SHARP;
      _map[(i*12)+9][2]=NONE;
      _map[(i*12)+10][2]=SHARP;
      _map[(i*12)+11][2]=NONE;
    }

    //dependencies

    _map[(i*12)][3]=(i*12)+1;
    _map[(i*12)+1][3]=(i*12);
    _map[(i*12)+2][3]=(i*12)+3;
    _map[(i*12)+3][3]=(i*12)+2;
    _map[(i*12)+4][3]=(i*12)+4;
    _map[(i*12)+5][3]=(i*12)+6;
    _map[(i*12)+6][3]=(i*12)+5;
    _map[(i*12)+7][3]=(i*12)+8;
    if (i<10){
      _map[(i*12)+8][3]=(i*12)+7;
      _map[(i*12)+9][3]=(i*12)+10;
      _map[(i*12)+10][3]=(i*12+9);
      _map[(i*12)+11][3]=(i*12+11);
    }
  }
}
  








