/* Code pinched from - - -
 *
 * GenericFeature and FeatureList classes.
 * Author:	Giovanni Pezzino
 * History:     Adapted slightly by Bruce Cropley for TEAMGO 28/10/95
 *
 * Modified for the Cantor project by P.J.Leonard
 *
 */

#ifndef _JList_H
#define _JList_H

#include "assert.h"

///
class JListBase 
{
    
  ///
  friend class JListBaseIterator;
    
protected:
  ///
  JListBase( int clustSize = 10 );
  ///
  virtual ~JListBase();

  /// if check for duplicates then will not add a duplicate
  /// TRUE if it did not contained element
  bool add(void *fea, const bool check = true );

  /// Note  remove destroys the order.
  /// TRUE if it contained element
  bool remove(const void *fea );

  bool contains(const void *fea ) const;

  void * first() const;

  void * at(int index) const;

public:

  int  count() const;

  void clear();

private:
  ///
  void   **  _things;  ///array of void pointers
  JListBase * _next;
    
  ///
  int _numElems;
  ///
  int _clusterSize;
};

///
class JListBaseIterator 
{
  public:
  ///
  JListBaseIterator(JListBase *sl )
    :  _head( sl ), _list( sl ), _index( 0 ) 
  {
    assert(sl != 0);
  }
  
  ///
  void increment();
  
protected:
  void *next();
  ///
  void *thingPtr() const;
  
private:
  ///
  JListBase *_head;
  ///
  JListBase *_list;
  ///
  int _index;
};



#endif








