#include <iostream.h>
#include <unistd.h>

#include "jam/JMidiIn.h"
#include "jam/JVoice.h"
#include "jam/JVoiceManager.h"
#include "jam/JMidiInDriver.h"
#include "jam/JDeviceManager.h"     
#include "jam/JDevice.h"            
#include "japp/JApplication.h"     

int main()
{
  // Wrapper for /dev/sequencer


  JDeviceManager *manager=JDeviceManager::the();

  JApplication japp;

  int nDev = manager->nOutDevice();
  int i;

  cout << "\n Supported Devices" << endl;

  for(i=0; i < nDev ; i++ ) {
    cout << "[" << i << "] " <<  manager->outDevice(i)->name() << endl;
  }

  do {
    cout << " Enter the device you want to torture :";
    cin  >> i;
  } while (i <0 && i >= nDev);

  JVoiceManager::the()->setDefaultDevice(i);

  // Wrapper for the midi in stream

  
  assert(manager->nInDevice() > 0 );

  JMidiIn *midiIn=manager->midiIn(0);

  // We can have a voice with no track providing we do not try to record !

  JVoice *voice =   JVoiceManager::the()->defaultVoice();

  midiIn->attach(voice);

  cout << " ^C to quit " << endl;

  while(1);

}










