#include <iostream.h>
#include "rhytmcor.h"
#include "rcorblk.h"
#include "beatblk.h"
#include "phrase.h"
#include "iterator.h"
#include "rhytmblk.h"


rhythm_correlate_c::rhythm_correlate_c(){
  beat_array_main_ptr = 0;
  beat_array_shift_ptr = 0;
  corr_list_ptr = 0;
}


rhythm_correlate_c::rhythm_correlate_c(phrase_c *phrase_p){
  beat_array_main_ptr = 0;
  beat_array_shift_ptr = 0;
  corr_list_ptr = 0;
  phrase_ptr = phrase_p;
}

void rhythm_correlate_c::remove_all(){
//  int a;
//  char next_c;
  rhythm_corr_block_c *del_p;

  if(corr_list_ptr != 0) do{
		if(corr_list_ptr->linkR_ptr != corr_list_ptr){
		  corr_list_ptr->linkR_ptr->linkR_ptr->change_linkL(corr_list_ptr);
		  del_p = corr_list_ptr->change_linkR(corr_list_ptr->linkR_ptr->
														  linkR_ptr);
		}else{
		  del_p = corr_list_ptr;
		  corr_list_ptr = 0;
		}

		if(del_p->main_match_array_ptr != 0 ){
		  if(del_p->no_matches_int > 1)
			 delete [] del_p->main_match_array_ptr;
		  else
			 delete del_p->main_match_array_ptr;
		}

		if(del_p->main_gap_array_ptr != NULL){
		  if(del_p->no_main_gaps_int > 1)
			 delete [] del_p->main_gap_array_ptr;
		  else
			 delete del_p->main_gap_array_ptr;
		}

		if(del_p->comp_gap_array_ptr != NULL){
		  if(del_p->no_comp_gaps_int > 1)
			 delete [] del_p->comp_gap_array_ptr;
		  else
			 delete del_p->comp_gap_array_ptr;
		}

		if(del_p->total_shift_ptr != NULL)
		  delete del_p->total_shift_ptr;

		delete del_p;

	 }while(corr_list_ptr != NULL);
}

void rhythm_correlate_c::display_correlation(int all_i){
  int a;
  char next_c;
  rhythm_corr_block_c *current_corr_blk_p;

  cout << "\nHit return key for Correlation info..." << endl;

  if(corr_list_ptr != NULL){
	 current_corr_blk_p = corr_list_ptr;

	 do{
		cin.get(next_c);

		cout << "Weight: " << current_corr_blk_p->corr_weight_int << endl;

		if(all_i == 1){
		  for(a = 0; a < current_corr_blk_p->no_matches_int; a++){
			 cout << "match " << a << ": "
					<< current_corr_blk_p->main_match_array_ptr[a].beat() << ", "
					<< current_corr_blk_p->main_match_array_ptr[a].numerator() <<
					"/" << current_corr_blk_p->main_match_array_ptr[a].denominator()
					<< endl;
		  }
		  for(a = 0; a < current_corr_blk_p->no_comp_gaps_int; a++){
			 cout << "comp gap " << a << ": "
					<< current_corr_blk_p->comp_gap_array_ptr[a].beat() << ", "
					<< current_corr_blk_p->comp_gap_array_ptr[a].numerator() <<
					"/" << current_corr_blk_p->comp_gap_array_ptr[a].denominator()
					<< endl;
		  }
		  for(a = 0; a < current_corr_blk_p->no_main_gaps_int; a++){
			 cout << "main gap " << a << ": "
					<< current_corr_blk_p->main_gap_array_ptr[a].beat() << ", "
					<< current_corr_blk_p->main_gap_array_ptr[a].numerator() <<
					"/" << current_corr_blk_p->main_gap_array_ptr[a].denominator()
					<< endl;
		  }
		}

		current_corr_blk_p = current_corr_blk_p->linkR_ptr;

	 }while(current_corr_blk_p != corr_list_ptr);
  }

  cout << "\nEND of correlation info..." << endl;
}

void rhythm_correlate_c::rearrange_corr(){
  rhythm_corr_block_c *current_corr_blk_p;
  rhythm_corr_block_c *	left_p;
  rhythm_corr_block_c *	right_p;
  rhythm_corr_block_c *	far_right_p;
  int change_made_i;

  if((corr_list_ptr != NULL)&&(corr_list_ptr->linkR_ptr != corr_list_ptr)){

	 current_corr_blk_p = corr_list_ptr;

	 do{
		if(current_corr_blk_p == corr_list_ptr)
		  change_made_i = 0;

		if((current_corr_blk_p->linkR_ptr->corr_weight_int >
			 current_corr_blk_p->corr_weight_int)
			 &&(current_corr_blk_p->linkR_ptr != corr_list_ptr)){

		  if(current_corr_blk_p == corr_list_ptr)
			 corr_list_ptr = current_corr_blk_p->linkR_ptr;

		  far_right_p = current_corr_blk_p->linkR_ptr->
												change_linkR(current_corr_blk_p);
		  far_right_p->change_linkL(current_corr_blk_p);
		  right_p = current_corr_blk_p->change_linkR(far_right_p);
		  left_p = current_corr_blk_p->change_linkL(right_p);
		  right_p->change_linkL(left_p);
		  left_p->change_linkR(right_p);

		  change_made_i = 1;
		}

		current_corr_blk_p = current_corr_blk_p->linkR_ptr;
	 }while((current_corr_blk_p != corr_list_ptr) || (change_made_i == 1));
  }
}

void rhythm_correlate_c::create_beat_arrays(){
//  beat_block_c *beat_block_p;
  int fraction_array_p[3];
  int i;
  char d;
  phrase_ptr->iterator()->set_iterator(phrase_ptr->phrase(),
													phrase_ptr->phrase());

  beat_array_main_ptr = new beat_block_c[phrase_ptr->no_beat_blocks()];
  if(beat_array_main_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  beat_array_shift_ptr = new beat_block_c[phrase_ptr->no_beat_blocks()];
  if(beat_array_shift_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }

  for(i = 0; i < phrase_ptr->no_beat_blocks(); i++){
	 fraction_array_p[0] =
					phrase_ptr->iterator()->rhythm_block()->beat();
	 fraction_array_p[1] =
					phrase_ptr->iterator()->rhythm_block()->numerator();
	 fraction_array_p[2] =
					phrase_ptr->iterator()->rhythm_block()->denominator();

	 beat_array_shift_ptr[i].change_beat(fraction_array_p);
	 beat_array_main_ptr[i].change_beat(fraction_array_p);

	 phrase_ptr->iterator()->iterate(0, 1);
  }
}

void rhythm_correlate_c::delete_beat_arrays(){
  if(phrase_ptr->no_beat_blocks() > 1)
	 delete [] beat_array_main_ptr;
  else
	 delete beat_array_main_ptr;

  if(phrase_ptr->no_beat_blocks() > 1)
	 delete [] beat_array_shift_ptr;
  else
	 delete beat_array_shift_ptr;

  beat_array_main_ptr = NULL;
  beat_array_shift_ptr = NULL;
}

void rhythm_correlate_c::rhythm_analyse(){
  int weight_i = phrase_ptr->no_beat_blocks() * 25;
  int no_store_groups_i;
  int exit_i = 0;
  int subtract_i = 0;
  int add_i = 0;
  char d;

  // Update private members with current phrase data //
  phrase_ptr->update_phrase_info();

  // Remove any previous correlation info //
  remove_all();

  do{
	 create_beat_arrays();

	 if((subtract_i == 1)&&(add_i == 1))
		exit_i = 1;
	 no_store_groups_i = rhythm_correlate(2, weight_i);
	 delete_beat_arrays();
	 if(weight_i < 0)
		exit_i = 1;
	 else if(no_store_groups_i < 5){
		weight_i = weight_i - 50;
		subtract_i = 1;
	 }else if(no_store_groups_i > 20){
		weight_i = weight_i + 50;
		add_i = 1;
	 }else
		exit_i = 1;
  }while(exit_i == 0);

  number_of_corr_blocks_int = no_store_groups_i;

  // Sets up correlation data structures for use i.e. arrays //
  create_beat_arrays();
  rhythm_correlate(0, weight_i);
  delete_beat_arrays();

  // Stores all correlation information i.e. info into arrays //
  create_beat_arrays();
  rhythm_correlate(1, weight_i);
  delete_beat_arrays();

  // Rearranges the correlations to weight order //
  rearrange_corr();
}

int rhythm_correlate_c::rhythm_correlate(int store_loop_i, int store_weight_i){
  int a;
  int i;
  int j;
  int group_i;
  int exiti_i;
  int exitj_i;
  int exit_i;
  int nexti_i;
  int nextj_i;
  int nextinternalj_i;
  int lasti_in_group_i;
  int lasti_matched_i;
  int group_matches_i;
  int main_gaps_i;
  int comp_gaps_i;
  int group_gaps_since_match_i;
  int shift_groups_i;
  int shift_num_i = 0;
  int continuity_count_i;
  int compare_value_i;
//  int compare_value2_i;
  int store_this_shift_i;
  int store_group_i;
  int no_groups_to_store_i = 0;
  int fraction_array_p[3];
  double continuity_d;
  int corr_weight_i;
  double assesment_d;
  int main_start_array_p[3];
  int main_end_array_p[3];
  int comp_start_array_p[3];
  int comp_end_array_p[3];
  int total_shift_array_p[3] = {0, 0 ,1};
  int shift_by_array_p[3] = {0, 1 ,phrase_ptr->fraction()};
  int tmp_store_array_p[3];
  char d;

  rhythm_corr_block_c *current_corr_blk_p;
  rhythm_corr_block_c *corr_blk_ptr;

  if((store_loop_i == 1)&&(corr_list_ptr != NULL))
	 current_corr_blk_p = corr_list_ptr;

  do{
	 for(a = 0; a < phrase_ptr->no_beat_blocks(); a++)
		shift_beat(phrase_ptr->fraction(), &beat_array_shift_ptr[a]);

	 phrase_ptr->add_fractions(total_shift_array_p, shift_by_array_p,
						total_shift_array_p, 0);
	 shift_num_i++;

	 fraction_array_p[0] = 0;
	 fraction_array_p[1] = shift_num_i;
	 fraction_array_p[2] = phrase_ptr->fraction() *
								  phrase_ptr->beats_in_bar();

	 phrase_ptr->minimise_fraction(fraction_array_p);

	 group_matches_i = 0;
	 main_gaps_i = 0;
	 comp_gaps_i = 0;
	 assesment_d = 0;
	 shift_groups_i = 0;
	 group_i = 1;
	 store_this_shift_i = 0;
	 main_start_array_p[0] = 1;
	 main_start_array_p[1] = 0;
	 main_start_array_p[2] = 1;
	 nexti_i = 0;
	 nextj_i = 0;

	 phrase_ptr->add_fractions(total_shift_array_p, main_start_array_p,
										comp_start_array_p, 0);

	 if((store_loop_i == 1)&&(corr_list_ptr != NULL)
		 &&(phrase_ptr->compare_fractions(current_corr_blk_p->total_shift_ptr->
			 array(), total_shift_array_p) == 1)){

		store_this_shift_i = 1;
	 }

	 while(phrase_ptr->compare_fractions(comp_start_array_p,
			  beat_array_main_ptr[phrase_ptr->no_beat_blocks() - 1].array()) != 2){

		phrase_ptr->add_fractions(comp_start_array_p, shift_by_array_p,
										  main_end_array_p, 1);
		phrase_ptr->add_fractions(main_end_array_p, total_shift_array_p,
										  comp_end_array_p, 0);

		while((phrase_ptr->compare_fractions(
				 beat_array_shift_ptr[nextj_i].array(), main_end_array_p) != 2)
				 &&(nextj_i < phrase_ptr->no_beat_blocks() - 1))
		  nextj_i++;

		while((phrase_ptr->compare_fractions(
				 beat_array_main_ptr[nexti_i].array(), main_end_array_p) != 2)
				 &&(nexti_i < phrase_ptr->no_beat_blocks() - 1))
		  nexti_i++;

		if((phrase_ptr->compare_fractions(beat_array_main_ptr[nexti_i].array(),
			 comp_end_array_p) != 2)
		 &&(phrase_ptr->compare_fractions(beat_array_shift_ptr[nextj_i].array(),
			 comp_end_array_p) != 2)){

		  continuity_count_i = 0;
		  group_gaps_since_match_i = 0;
		  group_matches_i = 0;
		  main_gaps_i = 0;
		  comp_gaps_i = 0;
		  store_group_i = 0;
		  lasti_matched_i = 0;
		  lasti_in_group_i = 0;
		  i = nexti_i;
		  nextinternalj_i = nextj_i;
		  exiti_i = 0;

		  if((store_this_shift_i == 1)
			 &&(group_i == current_corr_blk_p->group_int)){
			 store_group_i = 1;
		  }

		  while(exiti_i == 0){
			 if(i == phrase_ptr->no_beat_blocks() - 1){
				exiti_i = 1;
				lasti_in_group_i = 1;
			 }
			 else if(phrase_ptr->compare_fractions(
						beat_array_main_ptr[i + 1].array(), comp_end_array_p) == 2){
				  exiti_i = 1;
				  lasti_in_group_i = 1;
			 }

			 j = nextinternalj_i;
			 exitj_i = 0;

			 while(exitj_i == 0){

				if(j == phrase_ptr->no_beat_blocks() - 1)
				  exitj_i = 1;
				else if(((phrase_ptr->compare_fractions(
							 beat_array_shift_ptr[j + 1].array(),
							 beat_array_main_ptr[i].array()) == 2)
							 &&(lasti_in_group_i != 1))
							 || (phrase_ptr->compare_fractions(
							 beat_array_shift_ptr[j + 1].array(),
							 comp_end_array_p) == 2))
				  exitj_i = 1;

				if(phrase_ptr->compare_fractions(beat_array_main_ptr[i].array(),
					beat_array_shift_ptr[j].array()) == 1){

				  if(store_group_i == 1){
					 phrase_ptr->add_fractions(beat_array_main_ptr[i].array(),
														total_shift_array_p,
														tmp_store_array_p, 1);

					 current_corr_blk_p->main_match_array_ptr[group_matches_i].
												change_beat(tmp_store_array_p);
				  }

				  group_matches_i++;

				  if(group_matches_i > 1)
					 continuity_count_i = continuity_count_i +
												 (10/((group_gaps_since_match_i/2) + 1));

				  group_gaps_since_match_i = 0;

				  exitj_i = 1;

				  if((lasti_in_group_i == 1)
					  &&(j != phrase_ptr->no_beat_blocks() - 1)){
					 exitj_i = 0;
					 lasti_matched_i = 1;
				  }

				  if(j < phrase_ptr->no_beat_blocks() - 1)
					 nextinternalj_i = j + 1;

				}else if(phrase_ptr->compare_fractions(
							beat_array_shift_ptr[j].array(), comp_end_array_p) != 2){

				  if(group_matches_i > 0)
					 group_gaps_since_match_i++;

				  if((phrase_ptr->compare_fractions(beat_array_main_ptr[i]
						.array(), beat_array_shift_ptr[j].array()) == 2)
					  || (lasti_in_group_i == 1)){

					 if(store_group_i == 1)
						current_corr_blk_p->comp_gap_array_ptr
							[comp_gaps_i].change_beat(beat_array_shift_ptr[j].array());

					 comp_gaps_i++;

					 if((exitj_i == 1)&&(lasti_matched_i != 1)){

						if(store_group_i == 1){
						  phrase_ptr->add_fractions(beat_array_main_ptr[i].array(),
															 total_shift_array_p,
															 tmp_store_array_p, 1);

						  current_corr_blk_p->main_gap_array_ptr[main_gaps_i].
													 change_beat(tmp_store_array_p);
						}

						main_gaps_i++;
					 }
				  }else{
					 if(store_group_i == 1){
						phrase_ptr->add_fractions(beat_array_main_ptr[i].array(),
														  total_shift_array_p,
														  tmp_store_array_p, 1);

						current_corr_blk_p->main_gap_array_ptr[main_gaps_i].
												  change_beat(tmp_store_array_p);
					 }

					 main_gaps_i++;
				  }
				}else if((phrase_ptr->compare_fractions(
							 beat_array_shift_ptr[j].array(), comp_end_array_p) == 2)
							&&(phrase_ptr->compare_fractions(
							 beat_array_main_ptr[i].array(), comp_end_array_p) != 2)
							&&(lasti_matched_i != 1)){

				  if(group_matches_i > 0)
					 group_gaps_since_match_i++;

				  if(store_group_i == 1){
					 phrase_ptr->add_fractions(beat_array_main_ptr[i].array(),
														total_shift_array_p,
														tmp_store_array_p, 1);

					 current_corr_blk_p->main_gap_array_ptr[main_gaps_i].
												change_beat(tmp_store_array_p);
				  }

				  main_gaps_i++;
				}
				j++;
			 }
			 i++;
		  }

		  assesment_d = 100 * ((group_matches_i/(1 +
								((main_gaps_i + comp_gaps_i)/2.0))));

		  continuity_d = 100 * (1 + (1.0 * continuity_count_i)/(1 +
									((main_gaps_i + comp_gaps_i)/4.0)));

		  corr_weight_i = (int)((assesment_d + continuity_d)
								 /(fraction_array_p[2]));

		  if(corr_weight_i >= store_weight_i){
			 if(store_loop_i == 0){

				exit_i = 0;
				current_corr_blk_p = corr_list_ptr;
				/*
				cout << "weight: " << corr_weight_i << endl;
				cout << "group: " << group_i << endl;
				cout << "comp gaps: " << comp_gaps_i << endl;
				cin.get(d);
            */
				corr_blk_ptr = new rhythm_corr_block_c(corr_weight_i, group_i,
														 total_shift_array_p, group_matches_i,
														 main_gaps_i, comp_gaps_i);
				if(corr_blk_ptr == NULL){
				  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
				  cin.get(d);
				}
				if(corr_list_ptr == NULL){
				  corr_list_ptr = corr_blk_ptr;
				  corr_list_ptr->change_linkL(corr_blk_ptr);
				  corr_list_ptr->change_linkR(corr_blk_ptr);
				}else{
				  corr_blk_ptr->change_linkL(current_corr_blk_p->linkL_ptr);
				  corr_blk_ptr->change_linkR(current_corr_blk_p);
				  current_corr_blk_p->linkL_ptr->change_linkR(corr_blk_ptr);
				  current_corr_blk_p->change_linkL(corr_blk_ptr);
				}
			 }else if(store_loop_i == 1){
				current_corr_blk_p = current_corr_blk_p->linkR_ptr;

				if(phrase_ptr->compare_fractions(current_corr_blk_p->
					total_shift_ptr->array(), total_shift_array_p) != 1)
				  store_this_shift_i = 0;

				store_group_i = 0;
				/*
				cout << "\nSTORING GROUP: " << group_i << endl;
				cout << "Main location: " << main_start_array_p[0] << ", "
					  << main_start_array_p[1] << "/" << main_start_array_p[2]
					  << " TO " << main_end_array_p[0] << ", " << main_end_array_p[1]
					  << "/" << main_end_array_p[2] << endl;
				cout << "Comp location: " << comp_start_array_p[0] << ", "
					  << comp_start_array_p[1] << "/" << comp_start_array_p[2]
					  << " TO " << comp_end_array_p[0] << ", " << comp_end_array_p[1]
					  << "/" << comp_end_array_p[2] << endl;
				cout << "Matches: " << group_matches_i << endl;
				cout << "Gaps: " << main_gaps_i << " + " << comp_gaps_i << endl;
				cout << "Groups: " << shift_groups_i << endl;
				cout << "Total shift: " << total_shift_array_p[0] << ", "
					  << total_shift_array_p[1] << "/" << total_shift_array_p[2]
					  << endl;
				cout << "Bar fraction: " << fraction_array_p[2] << endl;
				cout << "Assesment: " << assesment_d << endl;
				cout << "Continuity: " << continuity_d << endl;
				cout << "Store Recommendation: " << corr_weight_i << endl;

				cin.get(d);
				*/
			 }else
				no_groups_to_store_i++;
		  }
		}

		// Overwrites old main start with new one //
		phrase_ptr->add_fractions(main_start_array_p, total_shift_array_p,
										  main_start_array_p, 0);

		group_i++;
		shift_groups_i++;

		phrase_ptr->add_fractions(total_shift_array_p, main_start_array_p,
										  comp_start_array_p, 0);
		compare_value_i = phrase_ptr->compare_fractions(comp_start_array_p,
					  beat_array_main_ptr[phrase_ptr->no_beat_blocks() - 1].array());
	 }

	 compare_value_i = phrase_ptr->compare_fractions(
					  beat_array_shift_ptr[0].array(),
					  beat_array_main_ptr[phrase_ptr->no_beat_blocks() - 1].array());

  }while(compare_value_i != 2);

  return no_groups_to_store_i;
}

// Shift beat function
void rhythm_correlate_c::shift_beat(int shift_denom_i,
												beat_block_c *beat_block_p){
  int fraction_array_p[3];
//  char d;
  fraction_array_p[0] = 0;
  fraction_array_p[1] = 1;
  fraction_array_p[2] = shift_denom_i;

  phrase_ptr->add_fractions(beat_block_p->array(), fraction_array_p,
									 fraction_array_p, 0);

  (*beat_block_p).change_beat(fraction_array_p);
}

