#include <iostream.h>
#include <qapp.h>

#include <qsocknot.h>

#include "jam/JDeviceManager.h"  //  /dev/sequencer interface
#include "linux/JOSSDeviceManager.h"  //  /dev/sequencer interface

#include "jam/JComposition.h"
#include "jam/JVoice.h"
#include "jam/JMidiIn.h"
#include "jam/JDevice.h"



#include "jam/JMidiInController.h"
#include "jam/JFocus.h"
#include "jam/JConductor.h"
#include "jam/JMapper.h"
#include "jam/JScheduler.h"
#include "jam/JContext.h"

#include "qj/QJMainWidget.h"
#include "qj/QJMainMenu.h"
#include "qj/QJToolBox.h"
#include "qj/menuSetup.h"
#include "CBuildCommand.h"


int main( int argc, char ** argv )
{

  QApplication application( argc, argv );
  QApplication::setStyle(MotifStyle);

  new QJToolBox;

    
  // Set up the devices

  JDeviceManager *manager=JDeviceManager::the();

  new JOSSDeviceManager(manager);

  JDevice *device=manager->device(1);
  assert( device != 0 );
    

  JContext *context      = new JContext;


  JMidiIn *midiIn=manager->midiIn(0);


  CBuildCommand buildCommand(context);

  QJMainWidget mainWdgt(context);
  menuSetup(mainWdgt.menu(),context);

  mainWdgt.menu()->plugin("Plugin","Doit",&buildCommand);

  JMidiInController *midiRoute=0;

  if (midiIn != 0) {
    midiRoute    = new JMidiInController(midiIn);
    if (midiRoute != 0) context->focus()->attach(midiRoute);
  }

  application.setMainWidget(&mainWdgt);

  //  if (JToolBox::the()->query(" Timer "," launch timer "))

  scheduler.launch(JTime(10));

  mainWdgt.show();


  if (midiInDriver != 0)
    scheduler.setSliceClient(midiInDriver);

  application.exec();

  scheduler.statistics();

}










