#include <string.h>
#include <math.h>  // pow
#include "JX11BeepDevice.h"
#include "Beeper.h"

JX11BeepDevice::JX11BeepDevice()
  :JDevice("X11Beep")
{
  _beeper= new Beeper;
}

JX11BeepDevice::~JX11BeepDevice()
{
  delete _beeper;
}



bool
JX11BeepDevice::handle(JMidiOutEvent e)
{
  // TODO work out what frequency of midi pitch 0 really is 
  
  if (e.type() != JMidiOutType::NOTE_EFFECT) return false;
  
  if (e.value() == 0)  {
    _beeper->NoPlay();	
    return true;
  } else {
    int pitch=e.index();
    double freq = 18.0 * pow(2.0, ((double)pitch)/12.0 );
    _beeper->Play((int)freq,e.value(),5000);
  }
  return true;
}













