#include "QJKeyHandler.h"
#include <qfile.h>
#include <qdir.h>
#include <qstring.h>
#include <qtstream.h>
#include <iostream.h>

QJKeyHandler::QJKeyHandler():QObject(0,"KeyHandler")
{
  for(int i=0; i< 256 ; i++ ) _lookup[i]=0;


  QFile f(".pianorc");

  if (!f.open(IO_ReadOnly)) {
    QDir home=QDir::home();
    f.setName(home.filePath(".pianorc"));
    if (!f.open(IO_ReadOnly)) {
      cout << f.name() << " Not found " << endl;
      cout << " looked in current and home directories. " << endl;
      return;
    }
  }

  QTextStream in(&f);
  while(!in.eof()) {
    QString s=in.readLine();
    if (s.data()[0] == '#') continue;
    int note=s.toInt();

    s=in.readLine();
    char *ptr = &s.data()[0];
    while (*ptr != 0 ) {
      unsigned char c = *ptr++;
      _lookup[c] = note++;
    }
  }
}


bool QJKeyHandler::eventFilter( QObject *, QEvent *e )
{
  QKeyEvent *k;
  int note;
  unsigned char c;
  if ( e->type() == Event_KeyPress ) {    // key press
    k = (QKeyEvent*)e;
    c =  k->ascii();
    note = _lookup[c];
    if (note != 0) {
      emit noteOn(note);
//      debug( "Ate key press %d", k->key() );
      return TRUE;    
    }
  } else if ( e->type() == Event_KeyRelease ) {    
    k = (QKeyEvent*)e;
    c =  k->ascii();
    note = _lookup[c];
    if (note != 0) {
      emit noteOff(note);
//      debug( "Ate key release %d", k->key() );
      return TRUE;    
    }
  }

  return FALSE;                           // standard event processing
}
