#include <qapp.h>
#include <qpushbt.h>
#include <qwidget.h>
#include <qpicture.h>
#include <qpixmap.h>
#include <qbttngrp.h>
#include <qbitmap.h>
#include <math.h>
#include <qkeycode.h>
#include <qlayout.h>

#include "QJDurationWidget.h"
#include "jam/JDurationTool.h"

QJDurationWidget::QJDurationWidget(JDurationTool *tool,
				   QWidget *parent,
				   const char *name )
        : QWidget( parent, name ),
	  _dotted(0),
	  _durationTool(tool)
{
  
  QHBoxLayout * layout = new QHBoxLayout(this);

  _length=new QButtonGroup();
  _length->setExclusive(TRUE);
  _dots=new QButtonGroup();


#include "bitmaps/notes/pmin.xbm"
  _min = new QPushButton( "Minim", this, "minim" );
  _min->setFixedSize(20, 30 );
  layout->addWidget(_min);
  _min->setToggleButton(TRUE);
  QBitmap pm(pmin_width,pmin_height,pmin_bits,TRUE);
  pm.setMask(pm);
  _min->setPixmap(pm);
  _min->setAccel(Key_F1);
  _length->insert(_min);


#include "bitmaps/notes/psemib.xbm"
  _semib = new QPushButton("Semibreve",this,"semib");
  layout->addWidget(_semib);
  _semib->setFixedSize(20,30);
  _semib->setToggleButton(TRUE);
  _semib->setAccel(Key_F2);
  _semib->setPixmap(QBitmap(psemib_width,psemib_height,psemib_bits,TRUE));
  _length->insert(_semib);


#include "bitmaps/notes/pcrot.xbm"
  _crot = new QPushButton("Crotchet",this,"crot");
  layout->addWidget(_crot);
  _crot->setFixedSize(20,30);
  _crot->setToggleButton(TRUE);
  _crot->setAccel(Key_F3);
  _crot->setPixmap(QBitmap(pcrot_width,pcrot_height,pcrot_bits,TRUE));
  _length->insert(_crot);

#include "bitmaps/notes/pquav.xbm"
  _quav = new QPushButton("Quaver",this,"quav");
  layout->addWidget(_quav);
  _quav->setFixedSize(20,30);
  _quav->setToggleButton(TRUE);
  _quav->setPixmap(QBitmap(pquav_width,pquav_height,pquav_bits,TRUE));
  _quav->setAccel(Key_F4);
  _length->insert(_quav);

#include "bitmaps/notes/psquav.xbm"
  _squav = new QPushButton("Semiquaver",this,"squav");
  layout->addWidget(_squav);
  _squav->setFixedSize(20,30);
  _squav->setToggleButton(TRUE);
  _squav->setPixmap(QBitmap(psquav_width,psquav_height,psquav_bits,TRUE));
  _squav->setAccel(Key_F5);
  _length->insert(_squav);

#include "bitmaps/notes/pdsquav.xbm"
  _dsquav = new QPushButton("Demisemiquaver",this,"dsquav");
  layout->addWidget(_dsquav);
  _dsquav->setFixedSize(20,30);
  _dsquav->setToggleButton(TRUE);
  _dsquav->setPixmap(QBitmap(pdsquav_width,pdsquav_height,pdsquav_bits,TRUE));
  _dsquav->setAccel(Key_F6);
  _length->insert(_dsquav);

#include "bitmaps/notes/pdot.xbm"
  _dot = new QPushButton( "Dot", this, "dot" );
  layout->addWidget(_dot);
  _dot->setFixedSize( 20, 30 );
  _dot->setToggleButton(TRUE);
  _dot->setPixmap(QBitmap(pdot_width,pdot_height,pdot_bits,TRUE));
  _dot->setAccel(Key_F7);
  _dots->insert(_dot);

#include "bitmaps/notes/pddot.xbm"
  _ddot = new QPushButton("Ddot",this,"ddot");
  layout->addWidget(_ddot);
  _ddot->setFixedSize(20,30);
  _ddot->setToggleButton(TRUE);
  _ddot->setPixmap(QBitmap(pddot_width,pddot_height,pddot_bits,TRUE));
  _ddot->setAccel(Key_F8);
  _dots->insert(_ddot);

  layout->activate();
  adjustSize();

  connect( _dots, SIGNAL(clicked(int)), this, SLOT(updateDuration(int)) );
  connect( _length, SIGNAL(clicked(int)), this, SLOT(updateDuration(int)) );
  updateDuration(0);
}

#if 0
void 
QJDurationWidget::lengthHit(int b)
{
  // Make sure that if the button is clicked a second time it stays ON.
  _min->setOn(b==0);
  _semib->setOn(b==1);
  _crot->setOn(b==2);
  _quav->setOn(b==3);
  _squav->setOn(b==4);
  _dsquav->setOn(b==5);
  //  _hdsquav->setOn(b==6);

  _noteLength=1;

  for (int i=b;i<6;i++){
    _noteLength*=2;
  } 

  debug("Notelength set to %d", _noteLength);
  _durationTool->setDuration(duration());

}


void QJDurationWidget::dotHit(int b)
{
  if (b+1 == _dotted) {
    _dotted = 0;
  }
  else {
    _dotted = b+1;
  }

  setDuration(duration());
}
  
void 
QJDurationWidget::setDuration(const JDuration &dd){
 
  int d=(int)(floor(dd.rep()*16.0+0.5));

  int h=8;

  if (d==1) h=6;
  if (d==2) h=5;
  if (d==4) h=4;
  if (d==8) h=3;
  if (d==16) h=2;
  if (d==32) h=1;
  if (d==64) h=0;

  if (h<8) lengthHit(h);

  _durationTool->setDuration(duration());

}


JDuration 
QJDurationWidget::duration() const
{
  int nl;

  if (_dotted==0) nl = _noteLength*4;
  if (_dotted==1) nl = _noteLength*6;
  if (_dotted==2) nl = _noteLength*7;

  return(JDuration(0,nl,64));

}

#endif



void
QJDurationWidget::updateDuration(int)
{
  double d;
  if (_min->isOn())   d=4;
  if (_semib->isOn()) d=2;
  if (_crot->isOn())  d=1;
  if (_quav->isOn())  d=0.5;
  if (_squav->isOn()) d=0.25;
  if (_dsquav->isOn()) d=0.125;
  if (_dot->isOn()) d *= 1.5;
  if (_ddot->isOn()) d *= 1.25;
  _durationTool->setDuration(JDuration(d));
}







