#include <string.h>
#include "jam/JEffectList.h"
#include "jam/JEffect.h"
#include "JKmidDevice.h"
#include "rep/JMidiDefines.h"
#include "kmid/midiout.h"

JKmidDevice::  JKmidDevice(midiOut *midout)
  :JDevice(midout->devName()),
   _dev(midout)
{

}


JEffectList *
JKmidDevice::createEffectList()
{

  JEffectList *effectList=new JEffectList;

#define  ADD_EFFECT(cntrl,minV,maxV,name) \
  effectList->add(new JEffect(minV,maxV,JMidiOutType::CNTRL_EFFECT,cntrl,name),true)

  ADD_EFFECT(CTL_MODWHEEL,0,127,"Modulation");

  ADD_EFFECT(CTL_EXPRESSION,0,127,"Expression");

  ADD_EFFECT(CTL_MAIN_VOLUME,0,127,"Volume");


  ADD_EFFECT(CTL_BALANCE,0,127,"Balance");

  ADD_EFFECT(CTL_PAN,0,127,"Pan");

  ADD_EFFECT(CTL_SUSTAIN,0,127, "Sustain");

  ADD_EFFECT(CTL_EXT_EFF_DEPTH,0,127,"Reverb");

  ADD_EFFECT(CTL_CHORUS_DEPTH,0,127, "Chorus");

  return effectList;

}


bool
JKmidDevice::handle(JMidiOutEvent e)
{

  short value;

  switch(e.type()) {
  case JMidiOutType::NOTE_EFFECT:
    if (e.value() == 0) {
      _dev->noteOff(e.channelId(),e.index(), 0);
    }  else {
      _dev->noteOn(e.channelId(),e.index(),e.value());
    }
    break;
    
  case JMidiOutType::CNTRL_EFFECT:
    _dev->chnController(e.channelId(),e.index(),e.value());
    break;
    
  case JMidiOutType::PITCHBEND_EFFECT:
    value=e.value() + 0x2000;
    _dev->chnPitchBender(e.channelId(), (0x7f & value), (value>> 7) );
    break;
    

  case JMidiOutType::PROGRAM_EFFECT:
    _dev->chnPatchChange(e.channelId(), e.value());
    break;
    
  case JMidiOutType::ALLNOTEOFF_EFFECT:
    _dev->channelSilence(e.channelId());
    break;
    
  default:
    return false;
  }

  _dev->flush();
  return true;
}








