#include "JVoiceRecorder.h"
#include "JPart.h"
#include "JTrack.h"
#include "JQuantizeGroove.h"
#include "JGroovePhraseBuilder.h"
#include "JToolBox.h"        
#include "JVoice.h"
#include "rep/JMidiOutEvent.h"
#include "JPhrase.h"
#include "JContext.h"
#include "JFocus.h"
#include "JConductor.h"
#include "JPhrase.h"

JVoiceRecorder::JVoiceRecorder(JContext *context)
  :_track(0),
   _voice(0),
   _context(context)
{
}

JVoiceRecorder::~JVoiceRecorder()
{
  if (_voice != 0)
    _voice->setMonitor(0);
}

void
JVoiceRecorder::handle(JMidiOutEvent event)
{

  if (_context->conductor()->isPlaying()) {
    _recordSequence.append(new JRecordEvent(event));
  } else {
    notifyObservers(event);
  }

}


void
JVoiceRecorder::handle(JRecorderCommand command)
{
  switch(command.type()){

  case JRecorderCommand::RECORDOFF:
    saveToTrack();
    _track=0;
    if (_voice != 0) _voice->setMonitor(0);
    _voice=0;
    break;

  case JRecorderCommand::RECORDON:
    if (_voice != 0) _voice->setMonitor(0);
    if (_context->focus()->track() == 0) break;
    if (_context->focus()->voice() == 0) break;
    _voice=_context->focus()->voice();
    _track=_context->focus()->track();
    _voice->setMonitor(this);
    break;

  default:
    break;
  }
}




void
JVoiceRecorder::saveToTrack()
{
  JPhrase *phrase = 0;

  if (_recordSequence.count() == 0) return; 

  if (_track != 0) {
    if (JToolBox::the()->query("Record"," Save it ? ") ) {

      phrase=_track->newPhrase(_context->focus()->part());

      JQuantizeGroove groove(1440);
      JGroovePhraseBuilder builder(&groove,phrase);
      
#ifdef J_DEBUG
      //      cout << "SEQUENCE -->" << *sequence << endl;
#endif
      
      builder.buildPhrase(&_recordSequence);
    }
  }

  _recordSequence.clear(true);

  if (phrase != 0) {
    _context->focus()->setPhrase(phrase);
    
    phrase->update();
  }

}
    







