#include "JScoreNotator.h"
#include "JScorePainter.h"
#include "JNoteGesture.h"
#include "JPhrase.h"
#include "JPhraseController.h"
#include "JTrack.h"
#include "JMeter.h"
#include "JFocus.h"
#include "JBarIterator.h"
#include "JContext.h"

JScoreNotator::JScoreNotator(JScorePainter *p,JContext *c,JLRRep lr)
  :_scorePainter(p),_context(c),
   // TODO some very clever thing here
   _lrClear(lr.left()-JDuration(0.5), lr.right()+JDuration(0.5)),
   _lrPaint(lr.left()-JDuration(1.0), lr.right()+JDuration(1.0)),
   _style(NORMAL)
{
}

void
JScoreNotator::notateGesture(const JGesture *gesture)
{
  if (gesture->isType("$Note") ){
    JNoteGesture *note=(JNoteGesture *)gesture;
    _scorePainter->drawNote(note->start(),
			    note->duration(),
			    note->pitch(),
			    _style);
  } 

}


void
JScoreNotator::notateTrack(const JTrack *track)
{
  if (track == 0) return;

  _scorePainter->setName(track->name());

  _scorePainter->clear(_lrClear);


  JBarIterator * barIter=0;

  const JMeter *meter = track->meter();
  if ( meter != 0 ) {
    barIter = meter->createBarIterator(_lrPaint.left(),_lrPaint.right());
  }

  if ( barIter != 0 ){
    const JBar *bar;
    while( (bar = barIter->next()) != 0 ) {
      _scorePainter->drawBar(bar->beat(),bar->number());
    }
  }

  if (barIter != 0 )  delete barIter;


  JPhraseListIterator iter(track->phraseList());
  
  JPhrase *phrase;

  while( (phrase = iter.next()) != 0) {
    if (phrase != _context->focus()->phrase()) {
      _style = DULL;
      notatePhrase(phrase);
    }
  }

  phrase = _context->focus()->phrase();
  
  if (phrase != 0) {
    _style = NORMAL ;
    notatePhrase(phrase);
  }
}

void
JScoreNotator::notatePhrase(const JPhrase *phrase)
{

  if (phrase == 0) return;
  JGestureListIterator iter((JGestureList *)(phrase->gestureList()));
  
  const JGesture *hiGesture=0;

  JBeat left = _lrPaint.left();

  if (phrase->controller() != 0 )
    hiGesture = phrase->controller()->focus();

  JGesture *gesture;
  JStyle oldStyle=_style;
  while( (gesture = iter.next()) != 0) {
    
    if (gesture->end() < left ) continue;
    
    if (gesture->start() > left) {
      _scorePainter->drawRest(left,gesture->start()-left);
    }

    if (left < gesture->end()) {
      left=gesture->end();
    }

    if ( gesture == hiGesture) {
      _style = HILIGHT;
    }

    notateGesture(gesture);
    _style = oldStyle;

    if (gesture->start() > _lrPaint.right()) break;
  }
}








