#ifndef _JNoteGesture_H
#define _JNoteGesture_H


#include "JGesture.h"

class JNoteGesture:public JGesture
{

friend class JGestureFactory;

  JNoteGesture(){;}

public:
  JNoteGesture(JBeat b,JDuration d,int pitch,int vel);
  JGesture *   clone() const ;
  JNotator *   createNotator(JScorePainter *) const;
  JSequencer * createSequencer(JPlayer *) const;
  void         setDuration(JDuration d) { _d=d; }
  JBeat        end() const;
  int          pitch() const;
  int          velocity() const;
  JDuration    duration() const { return _d; }
  bool         tweak(double val,int index);
  const char **tweakNames() const;
  bool         write(ostream &) const;
  bool         read(JReader &);
  const char * typeName() const { return "$Note"; }
  virtual      JNoteGesture *noteGesture() { return this; }
private:
  int          _pitch;
  int          _vel;
  JDuration    _d;

};

inline
int
JNoteGesture::pitch() const
{
  return _pitch;
}
inline
int
JNoteGesture::velocity() const
{
  return _vel;
}

inline
JBeat
JNoteGesture::end() const
{
  return _start + _d;
}


#endif

