#ifndef _JScorePainter_H
#define _JScorePainter_H

#include "bool.h"
#include "JStyle.h"
#include "JNoteStyle.h"

class JBeat;
class JDuration;
class JStaveToScreen;
class JScoreCursor;
class JBeatList;

class JScorePainter
{

public:

  /// Clear everything !!!
  virtual void clear()=0;


  /*! 
    Wipe area from --- till 
    May adjust from and till if required. 
   */
  virtual void clear(JBeat &from,JBeat &till)=0;

  //! Dar a bar line
  virtual bool drawBar(const JBeat &beat,
		       int   num,
		       JStyle style=NORMAL)=0;
  

  //! Draw event return TRUE is it can FALSE if it is too stupid
  virtual bool drawNote(const JBeat &beat,
			const JDuration &duration,
			int   pitch,
			JStyle style=NORMAL,
			JNoteStyle noteStyle=DEFAULT)=0;

  virtual bool drawRest(const JBeat &beat,
			const JDuration &duration,
			int   pitch=71,
			JStyle style=NORMAL)=0;


  virtual void setName(const char *name)=0;

  /// Really display things now. (So you can cache if you want to).
  virtual void update()=0;

  /// Whats my map ?
  //  virtual JStaveToScreen *staveToScreen()=0;

  virtual void setCursorAt(const JBeat  &beat,int pitch)=0;

  virtual void cursorOn(bool on)=0;

};



#endif











