#include "JMidiInController.h"
#include "JFocus.h"
#include "JVoice.h"

JMidiInController::JMidiInController(JSubject<JMidiInEvent ,void> *midiIn)
  :_midiIn(midiIn),_observer(0)
{}

const char *
JMidiInController::name() const { return "MidiInController"; }

void 
JMidiInController::handle(const JFocus *focus)
{
  if (focus->voice() == _observer) return;
  if (_observer !=0)  _midiIn->detach(_observer);
  _observer=focus->voice();
  _midiIn->attach(_observer);
}


